/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCaptureSession;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.CaptureCallbackAdapter;
import androidx.camera.camera2.internal.CaptureCallbackContainer;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureCallbacks;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
final class CaptureCallbackConverter {
    private CaptureCallbackConverter() {
    }

    static CameraCaptureSession.CaptureCallback toCaptureCallback(CameraCaptureCallback cameraCaptureCallback) {
        if (cameraCaptureCallback == null) {
            return null;
        }
        ArrayList<CameraCaptureSession.CaptureCallback> list = new ArrayList<CameraCaptureSession.CaptureCallback>();
        CaptureCallbackConverter.toCaptureCallback(cameraCaptureCallback, list);
        return list.size() == 1 ? (CameraCaptureSession.CaptureCallback)list.get(0) : Camera2CaptureCallbacks.createComboCallback(list);
    }

    static void toCaptureCallback(CameraCaptureCallback cameraCaptureCallback, List<CameraCaptureSession.CaptureCallback> captureCallbackList) {
        if (cameraCaptureCallback instanceof CameraCaptureCallbacks.ComboCameraCaptureCallback) {
            CameraCaptureCallbacks.ComboCameraCaptureCallback comboCallback = (CameraCaptureCallbacks.ComboCameraCaptureCallback)cameraCaptureCallback;
            for (CameraCaptureCallback callback : comboCallback.getCallbacks()) {
                CaptureCallbackConverter.toCaptureCallback(callback, captureCallbackList);
            }
        } else if (cameraCaptureCallback instanceof CaptureCallbackContainer) {
            CaptureCallbackContainer callbackContainer = (CaptureCallbackContainer)cameraCaptureCallback;
            captureCallbackList.add(callbackContainer.getCaptureCallback());
        } else {
            captureCallbackList.add(new CaptureCallbackAdapter(cameraCaptureCallback));
        }
    }
}

