/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.Camera2CaptureOptionUnpacker;
import androidx.camera.camera2.internal.Camera2SessionOptionUnpacker;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.ImageCaptureOptionUnpacker;
import androidx.camera.camera2.internal.compat.workaround.PreviewPixelHDRnet;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;

@RequiresApi(value=21)
public final class Camera2UseCaseConfigFactory
implements UseCaseConfigFactory {
    final DisplayInfoManager mDisplayInfoManager;

    public Camera2UseCaseConfigFactory(@NonNull Context context) {
        this.mDisplayInfoManager = DisplayInfoManager.getInstance(context);
    }

    @NonNull
    public Config getConfig(@NonNull UseCaseConfigFactory.CaptureType captureType, int captureMode) {
        MutableOptionsBundle mutableConfig = MutableOptionsBundle.create();
        SessionConfig.Builder sessionBuilder = new SessionConfig.Builder();
        switch (captureType) {
            case IMAGE_CAPTURE: {
                sessionBuilder.setTemplateType(captureMode == 2 ? 5 : 1);
                break;
            }
            case PREVIEW: 
            case IMAGE_ANALYSIS: {
                sessionBuilder.setTemplateType(1);
                break;
            }
            case VIDEO_CAPTURE: {
                sessionBuilder.setTemplateType(3);
            }
        }
        if (captureType == UseCaseConfigFactory.CaptureType.PREVIEW) {
            PreviewPixelHDRnet.setHDRnet(sessionBuilder);
        }
        mutableConfig.insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, (Object)sessionBuilder.build());
        mutableConfig.insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, (Object)Camera2SessionOptionUnpacker.INSTANCE);
        CaptureConfig.Builder captureBuilder = new CaptureConfig.Builder();
        switch (captureType) {
            case IMAGE_CAPTURE: {
                captureBuilder.setTemplateType(captureMode == 2 ? 5 : 2);
                break;
            }
            case PREVIEW: 
            case IMAGE_ANALYSIS: {
                captureBuilder.setTemplateType(1);
                break;
            }
            case VIDEO_CAPTURE: {
                captureBuilder.setTemplateType(3);
            }
        }
        mutableConfig.insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, (Object)captureBuilder.build());
        mutableConfig.insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, (Object)(captureType == UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE ? ImageCaptureOptionUnpacker.INSTANCE : Camera2CaptureOptionUnpacker.INSTANCE));
        if (captureType == UseCaseConfigFactory.CaptureType.PREVIEW) {
            mutableConfig.insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, (Object)this.mDisplayInfoManager.getPreviewSize());
        }
        int targetRotation = this.mDisplayInfoManager.getMaxSizeDisplay().getRotation();
        mutableConfig.insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, (Object)targetRotation);
        return OptionsBundle.from((Config)mutableConfig);
    }
}

