/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.arch.lifecycle.GenericLifecycleObserver;
import android.arch.lifecycle.ReflectiveGenericLifecycleObserver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class Lifecycling {
    private static Constructor<? extends GenericLifecycleObserver> sREFLECTIVE;
    private static Map<Class, Constructor<? extends GenericLifecycleObserver>> sCallbackCache;

    Lifecycling() {
    }

    @NonNull
    static GenericLifecycleObserver getCallback(Object object) {
        if (object instanceof GenericLifecycleObserver) {
            return (GenericLifecycleObserver)object;
        }
        try {
            Class<?> klass = object.getClass();
            Constructor<? extends GenericLifecycleObserver> cachedConstructor = sCallbackCache.get(klass);
            if (cachedConstructor != null) {
                return cachedConstructor.newInstance(object);
            }
            cachedConstructor = Lifecycling.getGeneratedAdapterConstructor(klass);
            if (cachedConstructor != null) {
                if (!cachedConstructor.isAccessible()) {
                    cachedConstructor.setAccessible(true);
                }
            } else {
                cachedConstructor = sREFLECTIVE;
            }
            sCallbackCache.put(klass, cachedConstructor);
            return cachedConstructor.newInstance(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static Constructor<? extends GenericLifecycleObserver> getGeneratedAdapterConstructor(Class<?> klass) {
        Package aPackage = klass.getPackage();
        String fullPackage = aPackage != null ? aPackage.getName() : "";
        String name = klass.getCanonicalName();
        if (name == null) {
            return null;
        }
        String adapterName = Lifecycling.getAdapterName(fullPackage.isEmpty() ? name : name.substring(fullPackage.length() + 1));
        try {
            Class<?> aClass = Class.forName(fullPackage.isEmpty() ? adapterName : fullPackage + "." + adapterName);
            return aClass.getDeclaredConstructor(klass);
        }
        catch (ClassNotFoundException e) {
            Class<?> superclass = klass.getSuperclass();
            if (superclass != null) {
                return Lifecycling.getGeneratedAdapterConstructor(superclass);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    static String getAdapterName(String className) {
        return className.replace(".", "_") + "_LifecycleAdapter";
    }

    static {
        try {
            sREFLECTIVE = ReflectiveGenericLifecycleObserver.class.getDeclaredConstructor(Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        sCallbackCache = new HashMap<Class, Constructor<? extends GenericLifecycleObserver>>();
    }
}

