/*
 * Decompiled with CFR 0.152.
 */
package amldev.i18n;

import amldev.i18n.R;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.preference.PreferenceManager;
import android.support.v7.app.AlertDialog;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lamldev/i18n/LocaleHelper;", "", "()V", "SELECTED_LANGUAGE", "", "changeLang", "", "context", "Landroid/content/Context;", "lang", "getLanguage", "getPersistedData", "defaultLanguage", "languageOptionsDialog", "onAttach", "persist", "language", "restartApp", "setLocale", "updateResources", "library_release"})
public final class LocaleHelper {
    private static final String SELECTED_LANGUAGE = "SELECT_LANGUAGE";
    public static final LocaleHelper INSTANCE;

    @NotNull
    public final Context onAttach(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        String string2 = locale.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().language");
        return this.setLocale(context, this.getPersistedData(context, string2));
    }

    @NotNull
    public final String getLanguage(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        String string2 = locale.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().language");
        return this.getPersistedData(context, string2);
    }

    private final Context setLocale(Context context, String language) {
        this.persist(context, language);
        return this.updateResources(context, language);
    }

    private final String getPersistedData(Context context, String defaultLanguage) {
        String string2 = PreferenceManager.getDefaultSharedPreferences((Context)context).getString(SELECTED_LANGUAGE, defaultLanguage);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PreferenceManager.getDef\u2026ANGUAGE, defaultLanguage)");
        return string2;
    }

    private final void persist(Context context, String language) {
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
        editor.putString(SELECTED_LANGUAGE, language);
        editor.apply();
    }

    private final Context updateResources(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Configuration configuration = resources.getConfiguration();
        configuration.setLocale(locale);
        configuration.setLayoutDirection(locale);
        Context context2 = context.createConfigurationContext(configuration);
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.createConfigurationContext(configuration)");
        return context2;
    }

    public final void languageOptionsDialog(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)context.getResources().getString(R.string.make_your_language_selection));
        builder.setItems((CharSequence[])context.getResources().getStringArray(R.array.language_string), new DialogInterface.OnClickListener(context){
            final /* synthetic */ Context $context;

            public final void onClick(DialogInterface $noName_0, int item) {
                String string2 = this.$context.getResources().getStringArray(R.array.language_codes)[item];
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.resources.getStr\u2026ay.language_codes) [item]");
                LocaleHelper.access$setLocale(LocaleHelper.INSTANCE, this.$context, string2);
                LocaleHelper.access$restartApp(LocaleHelper.INSTANCE, this.$context);
            }
            {
                this.$context = context;
            }
        });
        builder.create().show();
    }

    public final void changeLang(@NotNull Context context, @NotNull String lang) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        boolean changeLanguage = false;
        if (Intrinsics.areEqual((Object)lang, (Object)this.getLanguage(context)) ^ true) {
            changeLanguage = true;
        }
        if (changeLanguage) {
            this.setLocale(context, lang);
            this.restartApp(context);
        }
    }

    private final void restartApp(Context context) {
        Intent restartAppIntent = new Intent(context, context.getClass());
        restartAppIntent.addFlags(0x10000000);
        context.startActivity(restartAppIntent);
        Context context2 = context;
        if (context2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
        }
        ((Activity)context2).finish();
        ((Activity)context).overridePendingTransition(0, 0);
    }

    private LocaleHelper() {
    }

    static {
        LocaleHelper localeHelper;
        INSTANCE = localeHelper = new LocaleHelper();
        SELECTED_LANGUAGE = SELECTED_LANGUAGE;
    }

    @NotNull
    public static final /* synthetic */ Context access$setLocale(LocaleHelper $this, @NotNull Context context, @NotNull String language) {
        return $this.setLocale(context, language);
    }

    public static final /* synthetic */ void access$restartApp(LocaleHelper $this, @NotNull Context context) {
        $this.restartApp(context);
    }
}

