/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.spring.boot.autoconfigure.config;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.score.stream.ConstraintStreamImplType;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.spring.boot.autoconfigure.config.SolverProperty;
import ai.timefold.solver.spring.boot.autoconfigure.config.TerminationProperties;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class SolverProperties {
    private String solverConfigXml;
    private EnvironmentMode environmentMode;
    private Boolean daemon;
    private String moveThreadCount;
    private DomainAccessType domainAccessType;
    private List<PreviewFeature> enabledPreviewFeatures;
    private Class<? extends NearbyDistanceMeter<?, ?>> nearbyDistanceMeterClass;
    @Deprecated(forRemoval=true, since="1.4.0")
    private ConstraintStreamImplType constraintStreamImplType;
    private Boolean constraintStreamAutomaticNodeSharing;
    @NestedConfigurationProperty
    private TerminationProperties termination;

    public String getSolverConfigXml() {
        return this.solverConfigXml;
    }

    public void setSolverConfigXml(String solverConfigXml) {
        this.solverConfigXml = solverConfigXml;
    }

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public Boolean getDaemon() {
        return this.daemon;
    }

    public void setDaemon(Boolean daemon) {
        this.daemon = daemon;
    }

    public String getMoveThreadCount() {
        return this.moveThreadCount;
    }

    public void setMoveThreadCount(String moveThreadCount) {
        this.moveThreadCount = moveThreadCount;
    }

    public DomainAccessType getDomainAccessType() {
        return this.domainAccessType;
    }

    public void setDomainAccessType(DomainAccessType domainAccessType) {
        this.domainAccessType = domainAccessType;
    }

    public List<PreviewFeature> getEnabledPreviewFeatures() {
        return this.enabledPreviewFeatures;
    }

    public void setEnabledPreviewFeatures(List<PreviewFeature> enabledPreviewFeatures) {
        this.enabledPreviewFeatures = enabledPreviewFeatures;
    }

    public Class<? extends NearbyDistanceMeter<?, ?>> getNearbyDistanceMeterClass() {
        return this.nearbyDistanceMeterClass;
    }

    public void setNearbyDistanceMeterClass(Class<? extends NearbyDistanceMeter<?, ?>> nearbyDistanceMeterClass) {
        this.nearbyDistanceMeterClass = nearbyDistanceMeterClass;
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public ConstraintStreamImplType getConstraintStreamImplType() {
        return this.constraintStreamImplType;
    }

    @Deprecated(forRemoval=true, since="1.4.0")
    public void setConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        this.constraintStreamImplType = constraintStreamImplType;
    }

    public Boolean getConstraintStreamAutomaticNodeSharing() {
        return this.constraintStreamAutomaticNodeSharing;
    }

    public void setConstraintStreamAutomaticNodeSharing(Boolean constraintStreamAutomaticNodeSharing) {
        this.constraintStreamAutomaticNodeSharing = constraintStreamAutomaticNodeSharing;
    }

    public TerminationProperties getTermination() {
        return this.termination;
    }

    public void setTermination(TerminationProperties termination) {
        this.termination = termination;
    }

    public void loadProperties(Map<String, Object> properties) {
        TreeSet<String> invalidKeySet = new TreeSet<String>(properties.keySet());
        invalidKeySet.removeAll(SolverProperty.getValidPropertyNames());
        if (!invalidKeySet.isEmpty()) {
            throw new IllegalStateException("The properties [%s] are not valid.\nMaybe try changing the property name to kebab-case.\nHere is the list of valid properties: %s".formatted(invalidKeySet, String.join((CharSequence)", ", SolverProperty.getValidPropertyNames())));
        }
        properties.forEach(this::loadProperty);
    }

    private void loadProperty(String key, Object value) {
        if (value == null) {
            return;
        }
        SolverProperty property = SolverProperty.forPropertyName(key);
        property.update(this, value);
    }
}

