/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.benchmark.impl.aggregator;

import ai.timefold.solver.benchmark.config.PlannerBenchmarkConfig;
import ai.timefold.solver.benchmark.config.report.BenchmarkReportConfig;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReport;
import ai.timefold.solver.benchmark.impl.report.BenchmarkReportFactory;
import ai.timefold.solver.benchmark.impl.result.BenchmarkResultIO;
import ai.timefold.solver.benchmark.impl.result.PlannerBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SingleBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SolverBenchmarkResult;
import ai.timefold.solver.benchmark.impl.result.SubSingleBenchmarkResult;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkAggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkAggregator.class);
    private File benchmarkDirectory = null;
    private BenchmarkReportConfig benchmarkReportConfig = null;
    private BenchmarkReport benchmarkReport = null;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public BenchmarkReportConfig getBenchmarkReportConfig() {
        return this.benchmarkReportConfig;
    }

    public void setBenchmarkReportConfig(BenchmarkReportConfig benchmarkReportConfig) {
        this.benchmarkReportConfig = benchmarkReportConfig;
    }

    public BenchmarkReport getBenchmarkReport() {
        return this.benchmarkReport;
    }

    public void setBenchmarkReport(BenchmarkReport benchmarkReport) {
        this.benchmarkReport = benchmarkReport;
    }

    public File aggregateBenchmarks(PlannerBenchmarkConfig benchmarkConfig) {
        File benchmarkDirectory = benchmarkConfig.getBenchmarkDirectory();
        if (!benchmarkDirectory.exists() || !benchmarkDirectory.isDirectory()) {
            throw new IllegalArgumentException("Benchmark directory does not exist: %s".formatted(benchmarkDirectory));
        }
        BenchmarkResultIO benchmarkResultIO = new BenchmarkResultIO();
        List<PlannerBenchmarkResult> plannerBenchmarkResults = benchmarkResultIO.readPlannerBenchmarkResultList(benchmarkDirectory);
        if (plannerBenchmarkResults.isEmpty()) {
            throw new IllegalArgumentException("No benchmark results found in directory: %s".formatted(benchmarkDirectory));
        }
        ArrayList<SingleBenchmarkResult> allSingleBenchmarkResults = new ArrayList<SingleBenchmarkResult>();
        HashMap<SolverBenchmarkResult, String> solverBenchmarkResultNameMap = new HashMap<SolverBenchmarkResult, String>();
        for (PlannerBenchmarkResult plannerResult : plannerBenchmarkResults) {
            for (SolverBenchmarkResult solverResult : plannerResult.getSolverBenchmarkResultList()) {
                allSingleBenchmarkResults.addAll(solverResult.getSingleBenchmarkResultList());
                solverBenchmarkResultNameMap.put(solverResult, solverResult.getName());
            }
        }
        this.setBenchmarkDirectory(benchmarkDirectory);
        this.setBenchmarkReportConfig(benchmarkConfig.getBenchmarkReportConfig());
        return this.aggregate(allSingleBenchmarkResults, solverBenchmarkResultNameMap);
    }

    public File aggregateSelectedBenchmarksInUi(List<SingleBenchmarkResult> selectedSingleBenchmarkResults, Map<SolverBenchmarkResult, String> solverBenchmarkResultNameMap) {
        return this.aggregate(selectedSingleBenchmarkResults, solverBenchmarkResultNameMap);
    }

    public File aggregateSelectedBenchmarks(PlannerBenchmarkConfig benchmarkConfig, List<String> selectedDirectoryNames) {
        File benchmarkDirectory = benchmarkConfig.getBenchmarkDirectory();
        if (!benchmarkDirectory.exists() || !benchmarkDirectory.isDirectory()) {
            throw new IllegalArgumentException("No benchmark results found in directory: %s".formatted(benchmarkDirectory));
        }
        BenchmarkResultIO benchmarkResultIO = new BenchmarkResultIO();
        List<PlannerBenchmarkResult> allPlannerResults = benchmarkResultIO.readPlannerBenchmarkResultList(benchmarkDirectory);
        ArrayList<SingleBenchmarkResult> selectedSingleBenchmarkResults = new ArrayList<SingleBenchmarkResult>();
        HashMap<SolverBenchmarkResult, String> solverBenchmarkResultNameMap = new HashMap<SolverBenchmarkResult, String>();
        for (PlannerBenchmarkResult plannerResult : allPlannerResults) {
            String benchmarkDirectoryName = plannerResult.getBenchmarkReportDirectory().getName();
            if (!selectedDirectoryNames.contains(benchmarkDirectoryName)) continue;
            LOGGER.info("Including benchmark results from directory: {}", (Object)benchmarkDirectoryName);
            for (SolverBenchmarkResult solverResult : plannerResult.getSolverBenchmarkResultList()) {
                selectedSingleBenchmarkResults.addAll(solverResult.getSingleBenchmarkResultList());
                solverBenchmarkResultNameMap.put(solverResult, solverResult.getName());
            }
        }
        if (selectedSingleBenchmarkResults.isEmpty()) {
            throw new IllegalArgumentException("No valid benchmark results found in the selected directories: %s".formatted(selectedDirectoryNames));
        }
        this.setBenchmarkDirectory(benchmarkDirectory);
        this.setBenchmarkReportConfig(benchmarkConfig.getBenchmarkReportConfig());
        return this.aggregate(selectedSingleBenchmarkResults, solverBenchmarkResultNameMap);
    }

    public List<String> getAvailableBenchmarkDirectories(PlannerBenchmarkConfig benchmarkConfig) {
        File benchmarkDirectory = benchmarkConfig.getBenchmarkDirectory();
        if (!benchmarkDirectory.exists() || !benchmarkDirectory.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<String> directories = new ArrayList<String>();
        File[] subdirs = benchmarkDirectory.listFiles(File::isDirectory);
        if (subdirs != null) {
            for (File subdir : subdirs) {
                File resultFile = new File(subdir, "plannerBenchmarkResult.xml");
                if (!resultFile.exists()) continue;
                directories.add(subdir.getName());
            }
        }
        return directories;
    }

    public File aggregateAndShowReportInBrowser(PlannerBenchmarkConfig benchmarkConfig) {
        File benchmarkDirectoryPath = this.aggregateBenchmarks(benchmarkConfig);
        this.showReportInBrowser();
        return benchmarkDirectoryPath;
    }

    private void showReportInBrowser() {
        Desktop desktop;
        if (this.benchmarkReport == null) {
            throw new IllegalStateException("No benchmark report available. Run aggregation first.");
        }
        File htmlOverviewFile = this.benchmarkReport.getHtmlOverviewFile();
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(htmlOverviewFile.getAbsoluteFile().toURI());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed showing htmlOverviewFile (%s) in the default browser.".formatted(htmlOverviewFile), e);
            }
        } else {
            LOGGER.warn("The default browser can't be opened to show htmlOverviewFile ({}).", (Object)htmlOverviewFile);
        }
    }

    private File aggregate(List<SingleBenchmarkResult> singleBenchmarkResultList, Map<SolverBenchmarkResult, String> solverBenchmarkResultNameMap) {
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkReportConfig (%s) must not be null.".formatted(new Object[]{this.benchmarkReportConfig}));
        }
        if (!this.benchmarkDirectory.exists()) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + String.valueOf(this.benchmarkDirectory) + ") must exist.");
        }
        if (this.benchmarkReportConfig == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (%s) must exist.".formatted(this.benchmarkDirectory));
        }
        if (singleBenchmarkResultList.isEmpty()) {
            throw new IllegalArgumentException("The singleBenchmarkResultList (%s) must not be empty.".formatted(singleBenchmarkResultList));
        }
        OffsetDateTime startingTimestamp = OffsetDateTime.now();
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            for (SubSingleBenchmarkResult subSingleBenchmarkResult : singleBenchmarkResult.getSubSingleBenchmarkResultList()) {
                subSingleBenchmarkResult.setSingleBenchmarkResult(singleBenchmarkResult);
            }
            singleBenchmarkResult.initSubSingleStatisticMaps();
        }
        if (solverBenchmarkResultNameMap != null) {
            for (Map.Entry entry : solverBenchmarkResultNameMap.entrySet()) {
                SolverBenchmarkResult result = (SolverBenchmarkResult)entry.getKey();
                String newName = (String)entry.getValue();
                if (result.getName().equals(newName)) continue;
                result.setName(newName);
            }
        }
        PlannerBenchmarkResult plannerBenchmarkResult = PlannerBenchmarkResult.createMergedResult(singleBenchmarkResultList);
        plannerBenchmarkResult.setStartingTimestamp(startingTimestamp);
        plannerBenchmarkResult.initBenchmarkReportDirectory(this.benchmarkDirectory);
        BenchmarkReportFactory benchmarkReportFactory = new BenchmarkReportFactory(this.benchmarkReportConfig);
        BenchmarkReport benchmarkReport = benchmarkReportFactory.buildBenchmarkReport(plannerBenchmarkResult);
        plannerBenchmarkResult.accumulateResults(benchmarkReport);
        benchmarkReport.writeReport();
        this.benchmarkReport = benchmarkReport;
        LOGGER.info("Aggregation ended: statistic html overview ({}).", (Object)benchmarkReport.getHtmlOverviewFile().getAbsolutePath());
        return benchmarkReport.getHtmlOverviewFile().getAbsoluteFile();
    }
}

