/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.nlp.language.opennlp;

import ai.idylnlp.model.nlp.language.LanguageDetectionException;
import ai.idylnlp.model.nlp.language.LanguageDetectionResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenNLPLanguageDetector
implements ai.idylnlp.model.nlp.language.LanguageDetector {
    private static final Logger LOGGER = LogManager.getLogger(OpenNLPLanguageDetector.class);
    private LanguageDetector detector;

    public OpenNLPLanguageDetector() throws IOException {
        InputStream in = ClassLoader.getSystemResourceAsStream("langdetect-183.bin");
        LanguageDetectorModel m = new LanguageDetectorModel(in);
        this.detector = new LanguageDetectorME(m);
        in.close();
    }

    public OpenNLPLanguageDetector(InputStream in) throws IOException {
        LanguageDetectorModel m = new LanguageDetectorModel(in);
        this.detector = new LanguageDetectorME(m);
    }

    public LanguageDetectionResponse detectLanguage(String text, int limit) throws LanguageDetectionException {
        LinkedList<ImmutablePair> pairs = new LinkedList<ImmutablePair>();
        int count = 0;
        for (Language language : this.detector.predictLanguages((CharSequence)text)) {
            pairs.add(new ImmutablePair((Object)language.getLang(), (Object)language.getConfidence()));
            if (++count == limit) break;
        }
        Collections.sort(pairs, new Comparator<Pair<String, Double>>(){

            @Override
            public int compare(Pair<String, Double> arg0, Pair<String, Double> arg1) {
                if ((Double)arg1.getRight() > (Double)arg0.getRight()) {
                    return 1;
                }
                if ((Double)arg0.getRight() > (Double)arg1.getRight()) {
                    return -1;
                }
                return 0;
            }
        });
        return new LanguageDetectionResponse(pairs);
    }
}

