/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.types.DataType;
import ai.djl.tensorflow.engine.TfDataType;
import ai.djl.tensorflow.engine.TfNDArray;
import ai.djl.util.PairList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.file.Path;
import org.tensorflow.EagerSession;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.Operand;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.LinSpace;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.linalg.MatrixDiag;
import org.tensorflow.op.random.RandomStandardNormal;
import org.tensorflow.op.random.RandomUniform;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TUint8;
import org.tensorflow.types.family.TType;

public class TfNDManager
extends BaseNDManager {
    static final TfNDManager SYSTEM_MANAGER = new SystemManager();
    private static int nameAssignment = 1;
    EagerSession eagerSession;
    Ops tf;
    private static Integer seed;

    private TfNDManager(NDManager parent, Device device) {
        super(parent, device);
    }

    static TfNDManager getSystemManager() {
        return SYSTEM_MANAGER;
    }

    public ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    EagerSession getEagerSession() {
        if (this.eagerSession == null) {
            this.eagerSession = EagerSession.options().async(true).build();
        }
        return this.eagerSession;
    }

    Ops getTf() {
        if (this.tf == null) {
            this.tf = Ops.create((ExecutionEnvironment)this.eagerSession);
        }
        return this.tf;
    }

    public static void setRandomSeed(Integer seed) {
        TfNDManager.seed = seed;
    }

    public static Integer getRandomSeed() {
        return seed;
    }

    static int nextNameAssignment() {
        return nameAssignment++;
    }

    public NDArray create(byte[] data) {
        Shape shape = Shape.of((long[])new long[]{data.length});
        return new TfNDArray((NDManager)this, TUint8.tensorOf((Shape)shape, (ByteDataBuffer)DataBuffers.of((byte[])data)));
    }

    public NDArray create(float[] data) {
        Shape shape = Shape.of((long[])new long[]{data.length});
        return new TfNDArray((NDManager)this, TFloat32.tensorOf((Shape)shape, (FloatDataBuffer)DataBuffers.of((float[])data)));
    }

    public NDArray create(int[] data) {
        Shape shape = Shape.of((long[])new long[]{data.length});
        return new TfNDArray((NDManager)this, TInt32.tensorOf((Shape)shape, (IntDataBuffer)DataBuffers.of((int[])data)));
    }

    public NDArray create(boolean[] data) {
        Shape shape = Shape.of((long[])new long[]{data.length});
        return new TfNDArray((NDManager)this, TBool.tensorOf((Shape)shape, (BooleanDataBuffer)DataBuffers.of((boolean[])data)));
    }

    public NDArray create(int data) {
        return new TfNDArray((NDManager)this, TInt32.scalarOf((int)data));
    }

    public NDArray create(float data) {
        return new TfNDArray((NDManager)this, TFloat32.scalarOf((float)data));
    }

    public NDArray create(ai.djl.ndarray.types.Shape shape, DataType dataType) {
        if (shape.dimension() == 0) {
            return this.create(0.0f).toType(dataType, false);
        }
        Tensor tensor = Tensor.of(TfDataType.toTf(dataType), (Shape)TfNDArray.toTfShape(shape));
        return new TfNDArray((NDManager)this, tensor);
    }

    public TfNDArray create(Tensor<?> tensor) {
        return new TfNDArray((NDManager)this, tensor);
    }

    public TfNDArray create(ByteBuffer data, ai.djl.ndarray.types.Shape shape) {
        try (Tensor tensor = Tensor.of((org.tensorflow.DataType)TUint8.DTYPE, (Shape)TfNDArray.toTfShape(shape), (ByteDataBuffer)DataBuffers.of((ByteBuffer)data));){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
            return tfNDArray;
        }
    }

    public TfNDArray create(Buffer data, ai.djl.ndarray.types.Shape shape, DataType dataType) {
        int size = data.remaining();
        DataType inputType = DataType.fromBuffer((Buffer)data);
        int numOfBytes = inputType.getNumOfBytes();
        ByteBuffer buf = this.allocateDirect(size * numOfBytes);
        switch (inputType) {
            case FLOAT32: {
                buf.asFloatBuffer().put((FloatBuffer)data);
                break;
            }
            case FLOAT64: {
                buf.asDoubleBuffer().put((DoubleBuffer)data);
                break;
            }
            case UINT8: 
            case INT8: 
            case BOOLEAN: {
                buf.put((ByteBuffer)data);
                break;
            }
            case INT32: {
                buf.asIntBuffer().put((IntBuffer)data);
                break;
            }
            case INT64: {
                buf.asLongBuffer().put((LongBuffer)data);
                break;
            }
            default: {
                throw new AssertionError((Object)"Show never happen");
            }
        }
        buf.rewind();
        ByteDataBuffer db = DataBuffers.of((ByteBuffer)buf);
        Tensor tensor = Tensor.of(TfDataType.toTf(dataType), (Shape)TfNDArray.toTfShape(shape), (ByteDataBuffer)db);
        return new TfNDArray((NDManager)this, tensor);
    }

    public NDArray createCSR(Buffer data, long[] indptr, long[] indices, ai.djl.ndarray.types.Shape shape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray createRowSparse(Buffer data, ai.djl.ndarray.types.Shape dataShape, long[] indices, ai.djl.ndarray.types.Shape shape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList load(Path path) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void invoke(String operation, NDArray[] src, NDArray[] dest, PairList<String, ?> params) {
    }

    public NDList invoke(String operation, NDList src, PairList<String, ?> params) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Engine getEngine() {
        return Engine.getEngine((String)"TensorFlow");
    }

    public NDArray zeros(ai.djl.ndarray.types.Shape shape, DataType dataType) {
        try (Tensor tensor = this.tf.zeros((Operand)this.tf.constant(shape.getShape()), TfDataType.toTf(dataType)).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
            return tfNDArray;
        }
    }

    public NDArray ones(ai.djl.ndarray.types.Shape shape, DataType dataType) {
        return this.fill(shape, 1, dataType);
    }

    public NDArray full(ai.djl.ndarray.types.Shape shape, float value, DataType dataType) {
        return this.fill(shape, Float.valueOf(value), dataType);
    }

    public NDArray fill(ai.djl.ndarray.types.Shape shape, Number value, DataType dataType) {
        switch (dataType) {
            case INT32: {
                try (Tensor tensor = this.tf.fill((Operand)this.tf.constant(shape.getShape()), (Operand)this.tf.constant(value.intValue())).asTensor();){
                    TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
                    return tfNDArray;
                }
            }
            case INT64: {
                try (Tensor tensor = this.tf.fill((Operand)this.tf.constant(shape.getShape()).asOutput(), (Operand)this.tf.constant(value.longValue())).asTensor();){
                    TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
                    return tfNDArray;
                }
            }
            case FLOAT16: {
                try (Tensor tensor = this.tf.fill((Operand)this.tf.constant(shape.getShape()).asOutput(), (Operand)this.tf.constant((int)value.shortValue())).asTensor();){
                    TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
                    return tfNDArray;
                }
            }
            case FLOAT64: {
                try (Tensor tensor = this.tf.fill((Operand)this.tf.constant(shape.getShape()).asOutput(), (Operand)this.tf.constant(value.doubleValue())).asTensor();){
                    TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
                    return tfNDArray;
                }
            }
        }
        try (Tensor tensor = this.tf.fill((Operand)this.tf.constant(shape.getShape()).asOutput(), (Operand)this.tf.constant(value.floatValue())).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
            return tfNDArray;
        }
    }

    public NDArray arange(float start, float stop, float step, DataType dataType) {
        if (stop <= start && step > 0.0f) {
            return this.create(new ai.djl.ndarray.types.Shape(new long[]{0L}), dataType);
        }
        try (Tensor tensor = this.tf.range(this.toConstant(Float.valueOf(start), dataType), this.toConstant(Float.valueOf(stop), dataType), this.toConstant(Float.valueOf(step), dataType)).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
            return tfNDArray;
        }
    }

    public NDArray eye(int rows, int cols, int k, DataType dataType) {
        return this.eyeHelper(rows, cols, k, dataType);
    }

    private <T extends TType> NDArray eyeHelper(int rows, int cols, int k, DataType dataType) {
        Operand diagonal = ((TfNDArray)this.ones(new ai.djl.ndarray.types.Shape(new long[]{Math.min(rows, cols)}), dataType)).getOperand();
        Operand value = ((TfNDArray)this.zeros(new ai.djl.ndarray.types.Shape(new long[]{1L}))).getOperand();
        MatrixDiag output = this.tf.linalg.matrixDiag(diagonal, (Operand)this.tf.constant(k), (Operand)this.tf.constant(rows), (Operand)this.tf.constant(cols), value);
        try (Tensor tensor = output.asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
            return tfNDArray;
        }
    }

    <T extends TType> Constant<T> toConstant(Number n, DataType jType) {
        return TfNDArray.getConstant(n, jType, this.tf);
    }

    public NDArray linspace(float start, float stop, int num, boolean endpoint) {
        if (num < 0) {
            throw new IllegalArgumentException("number of samples must be non-negative.");
        }
        if (num == 0) {
            return this.create(new ai.djl.ndarray.types.Shape(new long[]{0L}));
        }
        if (endpoint) {
            try (Tensor tensor = LinSpace.create((Scope)this.tf.scope(), (Operand)this.tf.constant(start), (Operand)this.tf.constant(stop), (Operand)this.tf.constant(num)).asTensor();){
                TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
                return tfNDArray;
            }
        }
        try (Tensor tensor = LinSpace.create((Scope)this.tf.scope(), (Operand)this.tf.constant(start), (Operand)this.tf.constant(stop), (Operand)this.tf.constant(num + 1)).asTensor();){
            NDArray nDArray = new TfNDArray((NDManager)this, tensor).get(new NDIndex(":-1", new Object[0]));
            return nDArray;
        }
    }

    public NDArray randomUniform(float low, float high, ai.djl.ndarray.types.Shape shape, DataType dataType) {
        Constant shapeOp = this.tf.constant(shape.getShape());
        org.tensorflow.DataType<? extends TType> dType = dataType == DataType.UNKNOWN ? TFloat32.DTYPE : TfDataType.toTf(dataType);
        Cast minVal = this.tf.dtypes.cast((Operand)this.tf.constant(low), dType, new Cast.Options[0]);
        Cast maxVal = this.tf.dtypes.cast((Operand)this.tf.constant(high), dType, new Cast.Options[0]);
        RandomUniform result = seed != null ? this.tf.random.randomUniform((Operand)shapeOp, dType, new RandomUniform.Options[]{RandomUniform.seed((Long)1234L), RandomUniform.seed2((Long)2234L)}) : this.tf.random.randomUniform((Operand)shapeOp, dType, new RandomUniform.Options[0]);
        try (Tensor tensor = this.tf.math.add((Operand)this.tf.math.mul((Operand)result, (Operand)this.tf.math.sub((Operand)maxVal, (Operand)minVal)), (Operand)minVal).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
            return tfNDArray;
        }
    }

    public NDArray randomNormal(float loc, float scale, ai.djl.ndarray.types.Shape shape, DataType dataType) {
        Cast shapeOp = this.tf.dtypes.cast((Operand)this.tf.constant(shape.getShape()), TInt32.DTYPE, new Cast.Options[0]);
        org.tensorflow.DataType<? extends TType> dType = dataType == DataType.UNKNOWN ? TFloat32.DTYPE : TfDataType.toTf(dataType);
        Cast mean = this.tf.dtypes.cast((Operand)this.tf.constant(loc), dType, new Cast.Options[0]);
        Cast std = this.tf.dtypes.cast((Operand)this.tf.constant(scale), dType, new Cast.Options[0]);
        RandomStandardNormal result = seed != null ? this.tf.random.randomStandardNormal((Operand)shapeOp, dType, new RandomStandardNormal.Options[]{RandomStandardNormal.seed((Long)1234L), RandomStandardNormal.seed2((Long)2234L)}) : this.tf.random.randomStandardNormal((Operand)shapeOp, dType, new RandomStandardNormal.Options[0]);
        try (Tensor tensor = this.tf.math.add((Operand)this.tf.math.mul((Operand)result, (Operand)std), (Operand)mean).asTensor();){
            TfNDArray tfNDArray = new TfNDArray((NDManager)this, tensor);
            return tfNDArray;
        }
    }

    public NDArray randomMultinomial(int n, NDArray pValues, ai.djl.ndarray.types.Shape shape) {
        return null;
    }

    public NDArray randomMultinomial(int n, NDArray pValues) {
        return null;
    }

    public NDManager getParentManager() {
        return this.parent;
    }

    public Device getDevice() {
        return this.device;
    }

    public TfNDManager newSubManager() {
        return this.newSubManager(this.device);
    }

    public TfNDManager newSubManager(Device device) {
        TfNDManager manager = new TfNDManager((NDManager)this, device);
        this.attach(manager.uid, (AutoCloseable)((Object)manager));
        manager.getEagerSession();
        manager.getTf();
        return manager;
    }

    public boolean isOpen() {
        return false;
    }

    public void detach(String resourceId) {
        this.resources.remove(resourceId);
    }

    public void close() {
        super.close();
        if (this.eagerSession != null) {
            this.eagerSession.close();
        }
    }

    private static final class SystemManager
    extends TfNDManager {
        SystemManager() {
            super(null, Device.defaultDevice());
        }

        public void attach(String resrouceId, AutoCloseable resource) {
        }

        @Override
        public void detach(String resourceId) {
        }

        @Override
        public void close() {
        }
    }
}

