/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.index.NDArrayIndexer;
import ai.djl.ndarray.index.dim.NDIndexBooleans;
import ai.djl.ndarray.index.full.NDIndexFullPick;
import ai.djl.ndarray.index.full.NDIndexFullSlice;
import ai.djl.tensorflow.engine.TfNDArray;
import ai.djl.tensorflow.engine.TfNDManager;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Squeeze;
import org.tensorflow.op.core.StridedSlice;

public class TfNDArrayIndexer
extends NDArrayIndexer {
    public NDArray get(NDArray array, NDIndexFullPick fullPick) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray get(NDArray array, NDIndexFullSlice fullSlice) {
        TfNDArray tfArray = (TfNDArray)array;
        Ops tf = ((TfNDManager)tfArray.getManager()).getTf();
        Constant begin = tf.constant(fullSlice.getMin());
        Constant end = tf.constant(fullSlice.getMax());
        Constant step = tf.constant(fullSlice.getStep());
        int[] toSqueeze = fullSlice.getToSqueeze();
        StridedSlice sliced = tf.stridedSlice(tfArray.asOperand(), (Operand)begin, (Operand)end, (Operand)step, new StridedSlice.Options[0]);
        if (toSqueeze.length > 0) {
            List squeeze = Arrays.stream(toSqueeze).mapToLong(i -> i).boxed().collect(Collectors.toList());
            sliced = tf.squeeze((Operand)sliced, new Squeeze.Options[]{Squeeze.axis(squeeze)});
        }
        return new TfNDArray(array.getManager(), (Operand<?>)sliced);
    }

    public void set(NDArray array, NDIndexFullSlice fullSlice, NDArray value) {
        throw new UnsupportedOperationException("Tensor cannot be modified after creation");
    }

    public void set(NDArray array, NDIndexBooleans indices, NDArray value) {
        throw new UnsupportedOperationException("Tensor cannot be modified after creation");
    }

    public void set(NDArray array, NDIndexFullSlice fullSlice, Number value) {
        throw new UnsupportedOperationException("Tensor cannot be modified after creation");
    }
}

