/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine.javacpp;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "jnitensorflow";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-[a-z]+)?)(-SNAPSHOT)?(-\\d+)?");

    private LibUtils() {
    }

    public static void loadLibrary() {
        String libName = LibUtils.getLibName();
        if (libName != null) {
            logger.debug("Loading TensorFlow library from: {}", (Object)libName);
            String path = new File(libName).getParentFile().toString();
            System.setProperty("org.bytedeco.javacpp.platform.preloadpath", path);
            System.setProperty("org.bytedeco.javacpp.maxBytes", "0");
            System.setProperty("org.bytedeco.javacpp.maxPhysicalBytes", "0");
        }
    }

    public static String getLibName() {
        String libName = LibUtils.findOverrideLibrary();
        if (libName == null && (libName = LibUtils.findLibraryInClasspath()) == null) {
            libName = LIB_NAME;
        }
        return libName;
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = System.getenv("TENSORFLOW_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static synchronized String findLibraryInClasspath() {
        Enumeration<URL> urls;
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("native/lib/tensorflow.properties");
            if (url == null) {
                logger.debug("tensorflow.properties not found in class path.");
                return null;
            }
            urls = Thread.currentThread().getContextClassLoader().getResources("native/lib/tensorflow.properties");
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
        if (!urls.hasMoreElements()) {
            logger.debug("tensorflow.properties not found in class path.");
            return null;
        }
        Platform systemPlatform = Platform.fromSystem();
        try {
            Platform matching = null;
            Platform placeholder = null;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Platform platform = Platform.fromUrl((URL)url);
                if (platform.isPlaceholder()) {
                    placeholder = platform;
                    continue;
                }
                if (!platform.matches(systemPlatform)) continue;
                matching = platform;
                break;
            }
            if (matching != null) {
                return LibUtils.loadLibraryFromClasspath(matching);
            }
            if (placeholder != null) {
                try {
                    return LibUtils.downloadTensorFlow(placeholder);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to download Tensorflow native library", e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read Tensorflow native library jar properties", e);
        }
        throw new IllegalStateException("Your Tensorflow native library jar does not match your operating system. Make sure that the Maven Dependency Classifier matches your system type.");
    }

    private static String loadLibraryFromClasspath(Platform platform) {
        String string;
        block21: {
            Path tmp = null;
            try {
                String libName = System.mapLibraryName(LIB_NAME);
                Path cacheFolder = Utils.getEngineCacheDir((String)"tensorflow");
                logger.debug("Using cache dir: {}", (Object)cacheFolder);
                Path dir = cacheFolder.resolve(platform.getVersion() + platform.getClassifier());
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = path.toAbsolutePath().toString();
                    return string2;
                }
                Files.createDirectories(cacheFolder, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheFolder, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "/native/lib/" + file;
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        logger.info("Extracting {} to cache ...", (Object)file);
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
                if (tmp == null) break block21;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract Tensorflow native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        String mapLibraryName = System.mapLibraryName(LIB_NAME);
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            if (p.isFile() && p.getName().endsWith(mapLibraryName)) {
                return p.getAbsolutePath();
            }
            File file = new File(path, mapLibraryName);
            if (!file.exists() || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static String downloadTensorFlow(Platform platform) throws IOException {
        String version = platform.getVersion();
        String os = platform.getOsPrefix();
        String classifier = platform.getClassifier();
        String cudaArch = platform.getCudaArch();
        String flavor = platform.getFlavor();
        if (flavor.isEmpty()) {
            flavor = "cpu";
        }
        String libName = System.mapLibraryName(LIB_NAME);
        Path cacheDir = Utils.getEngineCacheDir((String)"tensorflow");
        logger.debug("Using cache dir: {}", (Object)cacheDir);
        Path dir = cacheDir.resolve(version + '-' + flavor + '-' + classifier);
        Path path = dir.resolve(libName);
        if (Files.exists(path, new LinkOption[0])) {
            return path.toAbsolutePath().toString();
        }
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        Path tmp = Files.createTempDirectory(cacheDir, "tmp", new FileAttribute[0]);
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected version: " + version);
        }
        String link = "https://publish.djl.ai/tensorflow-" + matcher.group(1);
        try {
            String string;
            try (InputStream is = new URL(link + "/files.txt").openStream();){
                List lines = Utils.readLines((InputStream)is);
                boolean found = LibUtils.downloadFiles(lines, link, os, flavor, tmp);
                if (!found && cudaArch != null) {
                    flavor = "cpu";
                    dir = cacheDir.resolve(version + '-' + flavor + '-' + classifier);
                    path = dir.resolve(libName);
                    if (Files.exists(path, new LinkOption[0])) {
                        logger.warn("No matching CUDA flavor for {} found: {}/sm_{}, fallback to CPU.", new Object[]{os, flavor, cudaArch});
                        String string2 = path.toAbsolutePath().toString();
                        return string2;
                    }
                    found = LibUtils.downloadFiles(lines, link, os, flavor, tmp);
                }
                if (!found) {
                    throw new UnsupportedOperationException("TensorFlow engine does not support this platform: " + os);
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
            }
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tmp != null) {
                Utils.deleteQuietly((Path)tmp);
            }
        }
    }

    private static boolean downloadFiles(List<String> lines, String link, String os, String flavor, Path tmp) throws IOException {
        boolean found = false;
        for (String line : lines) {
            if (!line.startsWith(os + '/' + flavor + '/')) continue;
            found = true;
            URL url = new URL(link + '/' + line.replace("+", "%2B"));
            String fileName = line.substring(line.lastIndexOf(47) + 1, line.length() - 3);
            logger.info("Downloading {} ...", (Object)url);
            GZIPInputStream fis = new GZIPInputStream(url.openStream());
            Throwable throwable = null;
            try {
                Files.copy(fis, tmp.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fis == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)fis).close();
            }
        }
        return found;
    }
}

