/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class RaggedCross<T extends TType, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "RaggedCross";
    private Output<T> outputValues;
    private Output<U> outputRowSplits;

    public static <T extends TType, U extends TNumber> RaggedCross<T, U> create(Scope scope, Iterable<Operand<?>> raggedValues, Iterable<Operand<?>> raggedRowSplits, Iterable<Operand<TInt64>> sparseIndices, Iterable<Operand<?>> sparseValues, Iterable<Operand<TInt64>> sparseShape, Iterable<Operand<?>> denseInputs, String inputOrder, Boolean hashedOutput, Long numBuckets, Long hashKey, DataType<T> outValuesType, DataType<U> outRowSplitsType) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInputList(Operands.asOutputs(raggedValues));
        opBuilder.addInputList(Operands.asOutputs(raggedRowSplits));
        opBuilder.addInputList(Operands.asOutputs(sparseIndices));
        opBuilder.addInputList(Operands.asOutputs(sparseValues));
        opBuilder.addInputList(Operands.asOutputs(sparseShape));
        opBuilder.addInputList(Operands.asOutputs(denseInputs));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("input_order", inputOrder);
        opBuilder.setAttr("hashed_output", hashedOutput);
        opBuilder.setAttr("num_buckets", numBuckets);
        opBuilder.setAttr("hash_key", hashKey);
        opBuilder.setAttr("out_values_type", outValuesType);
        opBuilder.setAttr("out_row_splits_type", outRowSplitsType);
        return new RaggedCross<T, U>(opBuilder.build());
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<U> outputRowSplits() {
        return this.outputRowSplits;
    }

    private RaggedCross(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputValues = operation.output(outputIdx++);
        this.outputRowSplits = operation.output(outputIdx++);
    }
}

