/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class TensorArrayConcat<T extends TType>
extends RawOp {
    public static final String OP_NAME = "TensorArrayConcatV3";
    private Output<T> value;
    private Output<TInt64> lengths;

    public static <T extends TType> TensorArrayConcat<T> create(Scope scope, Operand<?> handle, Operand<TFloat32> flowIn, DataType<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("TensorArrayConcat"));
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", dtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShapeExcept0 == null) continue;
                opBuilder.setAttr("element_shape_except0", opts.elementShapeExcept0);
            }
        }
        return new TensorArrayConcat<T>(opBuilder.build());
    }

    public static Options elementShapeExcept0(Shape elementShapeExcept0) {
        return new Options().elementShapeExcept0(elementShapeExcept0);
    }

    public Output<T> value() {
        return this.value;
    }

    public Output<TInt64> lengths() {
        return this.lengths;
    }

    private TensorArrayConcat(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
        this.lengths = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape elementShapeExcept0;

        public Options elementShapeExcept0(Shape elementShapeExcept0) {
            this.elementShapeExcept0 = elementShapeExcept0;
            return this;
        }

        private Options() {
        }
    }
}

