/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Concat;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.ExpandDims;
import org.tensorflow.op.core.Gather;
import org.tensorflow.op.core.OnesLike;
import org.tensorflow.op.core.ReduceProd;
import org.tensorflow.op.core.Reshape;
import org.tensorflow.op.core.Shape;
import org.tensorflow.op.core.Size;
import org.tensorflow.op.core.Slice;
import org.tensorflow.op.core.Where;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.math.FloorMod;
import org.tensorflow.op.math.NotEqual;
import org.tensorflow.op.math.Sub;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public abstract class Shapes {
    public static <T extends TType> Operand<T> flatten(Scope scope, Operand<T> operand) {
        return Shapes.flatten(scope, operand, TInt32.DTYPE);
    }

    public static <T extends TType, U extends TNumber> Operand<T> flatten(Scope scope, Operand<T> operand, DataType<U> dType) {
        Operand<U> flatShape = Shapes.flatten(scope, Shape.create(scope, operand, dType), dType);
        return Reshape.create(scope, operand, flatShape);
    }

    public static Operand<TInt32> flatten(Scope scope, Shape<TInt32> shape) {
        return Shapes.flatten(scope, shape, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> flatten(Scope scope, Shape<U> shape, DataType<U> dType) {
        return ExpandDims.create(scope, Shapes.size(scope, shape, dType), Cast.create(scope, Constant.scalarOf(scope, -1), TInt32.DTYPE, new Cast.Options[0]));
    }

    public static Operand<TInt32> size(Scope scope, Shape<TInt32> shape) {
        return Shapes.size(scope, shape, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> size(Scope scope, Shape<U> shape, DataType<U> dType) {
        Slice<U> dims = Slice.create(scope, shape, Cast.create(scope, Constant.arrayOf(scope, 0), dType, new Cast.Options[0]), ExpandDims.create(scope, Cast.create(scope, Constant.scalarOf(scope, -1), dType, new Cast.Options[0]), Constant.scalarOf(scope, -1)));
        return ReduceProd.create(scope, dims, Constant.scalarOf(scope, 0), new ReduceProd.Options[0]);
    }

    public static Operand<TInt32> size(Scope scope, Shape<TInt32> shape, Operand<TInt32> dim) {
        return Shapes.size(scope, shape, dim, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> size(Scope scope, Shape<U> shape, Operand<U> dim, DataType<U> dType) {
        return Slice.create(scope, shape, ExpandDims.create(scope, dim, Cast.create(scope, Constant.scalarOf(scope, -1), dType, new Cast.Options[0])), ExpandDims.create(scope, Cast.create(scope, Constant.scalarOf(scope, 1), dType, new Cast.Options[0]), Cast.create(scope, Constant.scalarOf(scope, -1), dType, new Cast.Options[0])));
    }

    public static <T extends TType> Operand<TInt32> size(Scope scope, Operand<T> input, Operand<TInt32> dim) {
        return Shapes.size(scope, input, dim, TInt32.DTYPE);
    }

    public static <T extends TType, U extends TNumber> Operand<U> size(Scope scope, Operand<T> input, Operand<U> dim, DataType<U> dType) {
        return Shapes.size(scope, Shape.create(scope, input, dType), dim, dType);
    }

    public static Operand<TInt32> numDimensions(Scope scope, Shape<TInt32> shape) {
        return Size.create(scope, shape, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> numDimensions(Scope scope, Shape<U> shape, DataType<U> dType) {
        return Size.create(scope, shape, dType);
    }

    public static <T extends TType> Operand<T> reduceDims(Scope scope, Operand<T> operand, Operand<TInt32> axis) {
        return Shapes.reduceDims(scope, operand, axis, TInt32.DTYPE);
    }

    public static <T extends TType, U extends TNumber> Operand<T> reduceDims(Scope scope, Operand<T> operand, Operand<U> axis, DataType<U> dType) {
        Shape<U> newShape = Shape.create(scope, operand, dType);
        return Reshape.create(scope, operand, Shapes.reduceDims(scope, newShape, axis, dType));
    }

    public static Operand<TInt32> reduceDims(Scope scope, Shape<TInt32> shape, Operand<TInt32> axis) {
        return Shapes.reduceDims(scope, shape, axis, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> reduceDims(Scope scope, Shape<U> shape, Operand<U> axis, DataType<U> dType) {
        Size<U> rank = Size.create(scope, shape, dType);
        axis = FloorMod.create(scope, axis, rank);
        Sub<U> remainder = Sub.create(scope, rank, axis);
        Slice<U> dims1 = Slice.create(scope, shape, Cast.create(scope, Constant.arrayOf(scope, 0), dType, new Cast.Options[0]), ExpandDims.create(scope, axis, Constant.scalarOf(scope, -1)));
        Slice<U> dims2 = Slice.create(scope, shape, ExpandDims.create(scope, axis, Constant.scalarOf(scope, -1)), ExpandDims.create(scope, Cast.create(scope, Constant.scalarOf(scope, -1), dType, new Cast.Options[0]), Constant.scalarOf(scope, -1)));
        ReduceProd<U> prod = ReduceProd.create(scope, dims2, Constant.scalarOf(scope, 0), ReduceProd.keepDims(Boolean.TRUE));
        return Concat.create(scope, Arrays.asList(dims1, prod), Constant.scalarOf(scope, 0));
    }

    public static Operand<TInt32> squeeze(Scope scope, Shape<TInt32> shape) {
        return Shapes.squeeze(scope, shape, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> squeeze(Scope scope, Shape<U> shape, DataType<U> dType) {
        NotEqual mask = NotEqual.create(scope, shape, Cast.create(scope, OnesLike.create(scope, shape), dType, new Cast.Options[0]), new NotEqual.Options[0]);
        return Gather.create(scope, shape, Where.create(scope, mask), Constant.scalarOf(scope, 0), new Gather.Options[0]);
    }

    public static Operand<TInt32> head(Scope scope, Shape<TInt32> shape) {
        return Shapes.head(scope, shape, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> head(Scope scope, Shape<U> shape, DataType<U> dType) {
        return Shapes.take(scope, shape, Cast.create(scope, Constant.scalarOf(scope, 1), dType, new Cast.Options[0]), dType);
    }

    public static Operand<TInt32> take(Scope scope, Shape<TInt32> shape, Operand<TInt32> n) {
        return Shapes.take(scope, shape, n, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> take(Scope scope, Shape<U> shape, Operand<U> n, DataType<U> dType) {
        return Slice.create(scope, shape, Cast.create(scope, Constant.arrayOf(scope, 0), dType, new Cast.Options[0]), ExpandDims.create(scope, n, Constant.scalarOf(scope, -1)));
    }

    public static Operand<TInt32> tail(Scope scope, Shape<TInt32> shape) {
        return Shapes.tail(scope, shape, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> tail(Scope scope, Shape<U> shape, DataType<U> dType) {
        return Shapes.takeLast(scope, shape, Cast.create(scope, Constant.scalarOf(scope, 1), dType, new Cast.Options[0]), dType);
    }

    public static <U extends TNumber> Operand<TInt32> takeLast(Scope scope, Shape<TInt32> shape, Operand<TInt32> n) {
        return Shapes.takeLast(scope, shape, n, TInt32.DTYPE);
    }

    public static <U extends TNumber> Operand<U> takeLast(Scope scope, Shape<U> shape, Operand<U> n, DataType<U> dType) {
        Size<U> rank = Size.create(scope, shape, dType);
        Sub<U> start = Sub.create(scope, rank, n);
        return Slice.create(scope, shape, ExpandDims.create(scope, start, Constant.scalarOf(scope, -1)), ExpandDims.create(scope, Cast.create(scope, Constant.scalarOf(scope, -1), dType, new Cast.Options[0]), Constant.scalarOf(scope, -1)));
    }

    public static Operand<TInt32> prepend(Scope scope, Shape<TInt32> shape, int firstDimension) {
        Constant<TInt32> dim = Constant.arrayOf(scope, firstDimension);
        return Concat.create(scope, Arrays.asList(dim, shape), Constant.scalarOf(scope, 0));
    }

    public static Operand<TInt64> prepend(Scope scope, Shape<TInt64> shape, long firstDimension) {
        Constant<TInt64> dim = Constant.arrayOf(scope, firstDimension);
        return Concat.create(scope, Arrays.asList(dim, shape), Constant.scalarOf(scope, 0));
    }

    public static <T extends TNumber> Operand<T> prepend(Scope scope, Operand<T> shape, Operand<T> shapeToPrepend) {
        return Concat.create(scope, Arrays.asList(shapeToPrepend, shape), Constant.scalarOf(scope, 0));
    }

    public static Operand<TInt32> append(Scope scope, Shape<TInt32> shape, int lastDimension) {
        Constant<TInt32> dim = Constant.arrayOf(scope, lastDimension);
        return Concat.create(scope, Arrays.asList(shape, dim), Constant.scalarOf(scope, 0));
    }

    public static Operand<TInt64> append(Scope scope, Shape<TInt64> shape, long lastDimension) {
        Constant<TInt64> dim = Constant.arrayOf(scope, lastDimension);
        return Concat.create(scope, Arrays.asList(shape, dim), Constant.scalarOf(scope, 0));
    }

    public static <T extends TNumber> Operand<T> append(Scope scope, Operand<T> shape, Operand<T> shapeToAppend) {
        return Concat.create(scope, Arrays.asList(shape, shapeToAppend), Constant.scalarOf(scope, 0));
    }
}

