/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class Copy<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Copy";
    private Output<T> output;

    public static <T extends TType> Copy<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.tensorName != null) {
                    opBuilder.setAttr("tensor_name", opts.tensorName);
                }
                if (opts.debugOpsSpec == null) continue;
                String[] debugOpsSpecArray = new String[opts.debugOpsSpec.size()];
                for (int i = 0; i < debugOpsSpecArray.length; ++i) {
                    debugOpsSpecArray[i] = (String)opts.debugOpsSpec.get(i);
                }
                opBuilder.setAttr("debug_ops_spec", debugOpsSpecArray);
            }
        }
        return new Copy<T>(opBuilder.build());
    }

    public static Options tensorName(String tensorName) {
        return new Options().tensorName(tensorName);
    }

    public static Options debugOpsSpec(List<String> debugOpsSpec) {
        return new Options().debugOpsSpec(debugOpsSpec);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Copy(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String tensorName;
        private List<String> debugOpsSpec;

        public Options tensorName(String tensorName) {
            this.tensorName = tensorName;
            return this;
        }

        public Options debugOpsSpec(List<String> debugOpsSpec) {
            this.debugOpsSpec = debugOpsSpec;
            return this;
        }

        private Options() {
        }
    }
}

