/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Scope;
import org.tensorflow.op.xla.BroadcastHelper;
import org.tensorflow.op.xla.ClusterOutput;
import org.tensorflow.op.xla.Conv;
import org.tensorflow.op.xla.Dequantize;
import org.tensorflow.op.xla.Dot;
import org.tensorflow.op.xla.DynamicSlice;
import org.tensorflow.op.xla.DynamicUpdateSlice;
import org.tensorflow.op.xla.Einsum;
import org.tensorflow.op.xla.Gather;
import org.tensorflow.op.xla.KeyValueSort;
import org.tensorflow.op.xla.Pad;
import org.tensorflow.op.xla.Recv;
import org.tensorflow.op.xla.ReplicaId;
import org.tensorflow.op.xla.SelfAdjointEig;
import org.tensorflow.op.xla.Send;
import org.tensorflow.op.xla.Sharding;
import org.tensorflow.op.xla.Sort;
import org.tensorflow.op.xla.Svd;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class XlaOps {
    private final Scope scope;

    XlaOps(Scope scope) {
        this.scope = scope;
    }

    public <T extends TType, U extends TNumber> BroadcastHelper<T> broadcastHelper(Operand<T> lhs, Operand<T> rhs, Operand<U> broadcastDims) {
        return BroadcastHelper.create(this.scope, lhs, rhs, broadcastDims);
    }

    public <T extends TType> ClusterOutput<T> clusterOutput(Operand<T> input) {
        return ClusterOutput.create(this.scope, input);
    }

    public <T extends TType, U extends TNumber> Conv<T> conv(Operand<T> lhs, Operand<T> rhs, Operand<U> windowStrides, Operand<U> padding, Operand<U> lhsDilation, Operand<U> rhsDilation, Operand<U> featureGroupCount, String dimensionNumbers, String precisionConfig) {
        return Conv.create(this.scope, lhs, rhs, windowStrides, padding, lhsDilation, rhsDilation, featureGroupCount, dimensionNumbers, precisionConfig);
    }

    public Dequantize dequantize(Operand<?> input, Float minRange, Float maxRange, String mode, Boolean transposeOutput) {
        return Dequantize.create(this.scope, input, minRange, maxRange, mode, transposeOutput);
    }

    public <T extends TType> Dot<T> dot(Operand<T> lhs, Operand<T> rhs, String dimensionNumbers, String precisionConfig) {
        return Dot.create(this.scope, lhs, rhs, dimensionNumbers, precisionConfig);
    }

    public <T extends TType, U extends TNumber> DynamicSlice<T> dynamicSlice(Operand<T> input, Operand<U> startIndices, Operand<U> sizeIndices) {
        return DynamicSlice.create(this.scope, input, startIndices, sizeIndices);
    }

    public <T extends TType, U extends TNumber> DynamicUpdateSlice<T> dynamicUpdateSlice(Operand<T> input, Operand<T> update, Operand<U> indices) {
        return DynamicUpdateSlice.create(this.scope, input, update, indices);
    }

    public <T extends TType> Einsum<T> einsum(Operand<T> a, Operand<T> b, String equation) {
        return Einsum.create(this.scope, a, b, equation);
    }

    public <T extends TType, U extends TNumber> Gather<T> gather(Operand<T> operand, Operand<U> startIndices, Operand<U> sliceSizes, String dimensionNumbers, Boolean indicesAreSorted) {
        return Gather.create(this.scope, operand, startIndices, sliceSizes, dimensionNumbers, indicesAreSorted);
    }

    public <T extends TNumber, U extends TType> KeyValueSort<T, U> keyValueSort(Operand<T> keys, Operand<U> values) {
        return KeyValueSort.create(this.scope, keys, values);
    }

    public <T extends TType, U extends TNumber> Pad<T> pad(Operand<T> input, Operand<T> paddingValue, Operand<U> paddingLow, Operand<U> paddingHigh, Operand<U> paddingInterior) {
        return Pad.create(this.scope, input, paddingValue, paddingLow, paddingHigh, paddingInterior);
    }

    public <T extends TType> Recv<T> recv(DataType<T> dtype, String tensorName, Shape shape) {
        return Recv.create(this.scope, dtype, tensorName, shape);
    }

    public ReplicaId replicaId() {
        return ReplicaId.create(this.scope);
    }

    public <T extends TType> SelfAdjointEig<T> selfAdjointEig(Operand<T> a, Boolean lower, Long maxIter, Float epsilon) {
        return SelfAdjointEig.create(this.scope, a, lower, maxIter, epsilon);
    }

    public <T extends TType> Send send(Operand<T> tensor, String tensorName) {
        return Send.create(this.scope, tensor, tensorName);
    }

    public <T extends TType> Sharding<T> sharding(Operand<T> input) {
        return Sharding.create(this.scope, input);
    }

    public <T extends TType> Sort<T> sort(Operand<T> input) {
        return Sort.create(this.scope, input);
    }

    public <T extends TType> Svd<T> svd(Operand<T> a, Long maxIter, Float epsilon, String precisionConfig) {
        return Svd.create(this.scope, a, maxIter, epsilon, precisionConfig);
    }
}

