/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Scope;
import org.tensorflow.op.train.AccumulatorApplyGradient;
import org.tensorflow.op.train.AccumulatorNumAccumulated;
import org.tensorflow.op.train.AccumulatorSetGlobalStep;
import org.tensorflow.op.train.AccumulatorTakeGradient;
import org.tensorflow.op.train.ApplyAdadelta;
import org.tensorflow.op.train.ApplyAdagrad;
import org.tensorflow.op.train.ApplyAdagradDa;
import org.tensorflow.op.train.ApplyAdam;
import org.tensorflow.op.train.ApplyAddSign;
import org.tensorflow.op.train.ApplyCenteredRmsProp;
import org.tensorflow.op.train.ApplyFtrl;
import org.tensorflow.op.train.ApplyGradientDescent;
import org.tensorflow.op.train.ApplyMomentum;
import org.tensorflow.op.train.ApplyPowerSign;
import org.tensorflow.op.train.ApplyProximalAdagrad;
import org.tensorflow.op.train.ApplyProximalGradientDescent;
import org.tensorflow.op.train.ApplyRmsProp;
import org.tensorflow.op.train.BatchMatMul;
import org.tensorflow.op.train.ConditionalAccumulator;
import org.tensorflow.op.train.GenerateVocabRemapping;
import org.tensorflow.op.train.MergeV2Checkpoints;
import org.tensorflow.op.train.NegTrain;
import org.tensorflow.op.train.PreventGradient;
import org.tensorflow.op.train.ResourceApplyAdadelta;
import org.tensorflow.op.train.ResourceApplyAdagradDa;
import org.tensorflow.op.train.ResourceApplyAdam;
import org.tensorflow.op.train.ResourceApplyAdamWithAmsgrad;
import org.tensorflow.op.train.ResourceApplyAddSign;
import org.tensorflow.op.train.ResourceApplyCenteredRmsProp;
import org.tensorflow.op.train.ResourceApplyFtrl;
import org.tensorflow.op.train.ResourceApplyGradientDescent;
import org.tensorflow.op.train.ResourceApplyKerasMomentum;
import org.tensorflow.op.train.ResourceApplyMomentum;
import org.tensorflow.op.train.ResourceApplyPowerSign;
import org.tensorflow.op.train.ResourceApplyProximalAdagrad;
import org.tensorflow.op.train.ResourceApplyProximalGradientDescent;
import org.tensorflow.op.train.ResourceApplyRmsProp;
import org.tensorflow.op.train.ResourceSparseApplyAdadelta;
import org.tensorflow.op.train.ResourceSparseApplyAdagrad;
import org.tensorflow.op.train.ResourceSparseApplyAdagradDa;
import org.tensorflow.op.train.ResourceSparseApplyCenteredRmsProp;
import org.tensorflow.op.train.ResourceSparseApplyFtrl;
import org.tensorflow.op.train.ResourceSparseApplyKerasMomentum;
import org.tensorflow.op.train.ResourceSparseApplyMomentum;
import org.tensorflow.op.train.ResourceSparseApplyProximalAdagrad;
import org.tensorflow.op.train.ResourceSparseApplyProximalGradientDescent;
import org.tensorflow.op.train.ResourceSparseApplyRmsProp;
import org.tensorflow.op.train.Restore;
import org.tensorflow.op.train.RestoreSlice;
import org.tensorflow.op.train.Save;
import org.tensorflow.op.train.SaveSlices;
import org.tensorflow.op.train.SdcaFprint;
import org.tensorflow.op.train.SdcaShrinkL1;
import org.tensorflow.op.train.SparseApplyAdadelta;
import org.tensorflow.op.train.SparseApplyAdagradDa;
import org.tensorflow.op.train.SparseApplyCenteredRmsProp;
import org.tensorflow.op.train.SparseApplyFtrl;
import org.tensorflow.op.train.SparseApplyMomentum;
import org.tensorflow.op.train.SparseApplyProximalAdagrad;
import org.tensorflow.op.train.SparseApplyProximalGradientDescent;
import org.tensorflow.op.train.SparseApplyRmsProp;
import org.tensorflow.op.train.TileGrad;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class TrainOps {
    private final Scope scope;

    TrainOps(Scope scope) {
        this.scope = scope;
    }

    public <T extends TType> AccumulatorApplyGradient accumulatorApplyGradient(Operand<TString> handle, Operand<TInt64> localStep, Operand<T> gradient) {
        return AccumulatorApplyGradient.create(this.scope, handle, localStep, gradient);
    }

    public AccumulatorNumAccumulated accumulatorNumAccumulated(Operand<TString> handle) {
        return AccumulatorNumAccumulated.create(this.scope, handle);
    }

    public AccumulatorSetGlobalStep accumulatorSetGlobalStep(Operand<TString> handle, Operand<TInt64> newGlobalStep) {
        return AccumulatorSetGlobalStep.create(this.scope, handle, newGlobalStep);
    }

    public <T extends TType> AccumulatorTakeGradient<T> accumulatorTakeGradient(Operand<TString> handle, Operand<TInt32> numRequired, DataType<T> dtype) {
        return AccumulatorTakeGradient.create(this.scope, handle, numRequired, dtype);
    }

    public <T extends TType> ApplyAdadelta<T> applyAdadelta(Operand<T> var, Operand<T> accum, Operand<T> accumUpdate, Operand<T> lr, Operand<T> rho, Operand<T> epsilon, Operand<T> grad, ApplyAdadelta.Options ... options) {
        return ApplyAdadelta.create(this.scope, var, accum, accumUpdate, lr, rho, epsilon, grad, options);
    }

    public <T extends TType> ApplyAdagrad<T> applyAdagrad(Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> grad, ApplyAdagrad.Options ... options) {
        return ApplyAdagrad.create(this.scope, var, accum, lr, grad, options);
    }

    public <T extends TType> ApplyAdagradDa<T> applyAdagradDa(Operand<T> var, Operand<T> gradientAccumulator, Operand<T> gradientSquaredAccumulator, Operand<T> grad, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<TInt64> globalStep, ApplyAdagradDa.Options ... options) {
        return ApplyAdagradDa.create(this.scope, var, gradientAccumulator, gradientSquaredAccumulator, grad, lr, l1, l2, globalStep, options);
    }

    public <T extends TType> ApplyAdam<T> applyAdam(Operand<T> var, Operand<T> m, Operand<T> v, Operand<T> beta1Power, Operand<T> beta2Power, Operand<T> lr, Operand<T> beta1, Operand<T> beta2, Operand<T> epsilon, Operand<T> grad, ApplyAdam.Options ... options) {
        return ApplyAdam.create(this.scope, var, m, v, beta1Power, beta2Power, lr, beta1, beta2, epsilon, grad, options);
    }

    public <T extends TType> ApplyAddSign<T> applyAddSign(Operand<T> var, Operand<T> m, Operand<T> lr, Operand<T> alpha, Operand<T> signDecay, Operand<T> beta, Operand<T> grad, ApplyAddSign.Options ... options) {
        return ApplyAddSign.create(this.scope, var, m, lr, alpha, signDecay, beta, grad, options);
    }

    public <T extends TType> ApplyCenteredRmsProp<T> applyCenteredRmsProp(Operand<T> var, Operand<T> mg, Operand<T> ms, Operand<T> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, ApplyCenteredRmsProp.Options ... options) {
        return ApplyCenteredRmsProp.create(this.scope, var, mg, ms, mom, lr, rho, momentum, epsilon, grad, options);
    }

    public <T extends TType> ApplyFtrl<T> applyFtrl(Operand<T> var, Operand<T> accum, Operand<T> linear, Operand<T> grad, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> l2Shrinkage, Operand<T> lrPower, ApplyFtrl.Options ... options) {
        return ApplyFtrl.create(this.scope, var, accum, linear, grad, lr, l1, l2, l2Shrinkage, lrPower, options);
    }

    public <T extends TType> ApplyGradientDescent<T> applyGradientDescent(Operand<T> var, Operand<T> alpha, Operand<T> delta, ApplyGradientDescent.Options ... options) {
        return ApplyGradientDescent.create(this.scope, var, alpha, delta, options);
    }

    public <T extends TType> ApplyMomentum<T> applyMomentum(Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> grad, Operand<T> momentum, ApplyMomentum.Options ... options) {
        return ApplyMomentum.create(this.scope, var, accum, lr, grad, momentum, options);
    }

    public <T extends TType> ApplyPowerSign<T> applyPowerSign(Operand<T> var, Operand<T> m, Operand<T> lr, Operand<T> logbase, Operand<T> signDecay, Operand<T> beta, Operand<T> grad, ApplyPowerSign.Options ... options) {
        return ApplyPowerSign.create(this.scope, var, m, lr, logbase, signDecay, beta, grad, options);
    }

    public <T extends TType> ApplyProximalAdagrad<T> applyProximalAdagrad(Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> grad, ApplyProximalAdagrad.Options ... options) {
        return ApplyProximalAdagrad.create(this.scope, var, accum, lr, l1, l2, grad, options);
    }

    public <T extends TType> ApplyProximalGradientDescent<T> applyProximalGradientDescent(Operand<T> var, Operand<T> alpha, Operand<T> l1, Operand<T> l2, Operand<T> delta, ApplyProximalGradientDescent.Options ... options) {
        return ApplyProximalGradientDescent.create(this.scope, var, alpha, l1, l2, delta, options);
    }

    public <T extends TType> ApplyRmsProp<T> applyRmsProp(Operand<T> var, Operand<T> ms, Operand<T> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, ApplyRmsProp.Options ... options) {
        return ApplyRmsProp.create(this.scope, var, ms, mom, lr, rho, momentum, epsilon, grad, options);
    }

    public <T extends TType> BatchMatMul<T> batchMatMul(Operand<T> x, Operand<T> y, BatchMatMul.Options ... options) {
        return BatchMatMul.create(this.scope, x, y, options);
    }

    public <T extends TType> ConditionalAccumulator conditionalAccumulator(DataType<T> dtype, Shape shape, ConditionalAccumulator.Options ... options) {
        return ConditionalAccumulator.create(this.scope, dtype, shape, options);
    }

    public GenerateVocabRemapping generateVocabRemapping(Operand<TString> newVocabFile, Operand<TString> oldVocabFile, Long newVocabOffset, Long numNewVocab, GenerateVocabRemapping.Options ... options) {
        return GenerateVocabRemapping.create(this.scope, newVocabFile, oldVocabFile, newVocabOffset, numNewVocab, options);
    }

    public MergeV2Checkpoints mergeV2Checkpoints(Operand<TString> checkpointPrefixes, Operand<TString> destinationPrefix, MergeV2Checkpoints.Options ... options) {
        return MergeV2Checkpoints.create(this.scope, checkpointPrefixes, destinationPrefix, options);
    }

    public NegTrain negTrain(Operand<TFloat32> wIn, Operand<TFloat32> wOut, Operand<TInt32> examples, Operand<TInt32> labels, Operand<TFloat32> lr, List<Long> vocabCount, Long numNegativeSamples) {
        return NegTrain.create(this.scope, wIn, wOut, examples, labels, lr, vocabCount, numNegativeSamples);
    }

    public <T extends TType> PreventGradient<T> preventGradient(Operand<T> input, PreventGradient.Options ... options) {
        return PreventGradient.create(this.scope, input, options);
    }

    public <T extends TType> ResourceApplyAdadelta resourceApplyAdadelta(Operand<?> var, Operand<?> accum, Operand<?> accumUpdate, Operand<T> lr, Operand<T> rho, Operand<T> epsilon, Operand<T> grad, ResourceApplyAdadelta.Options ... options) {
        return ResourceApplyAdadelta.create(this.scope, var, accum, accumUpdate, lr, rho, epsilon, grad, options);
    }

    public <T extends TType> ResourceApplyAdagradDa resourceApplyAdagradDa(Operand<?> var, Operand<?> gradientAccumulator, Operand<?> gradientSquaredAccumulator, Operand<T> grad, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<TInt64> globalStep, ResourceApplyAdagradDa.Options ... options) {
        return ResourceApplyAdagradDa.create(this.scope, var, gradientAccumulator, gradientSquaredAccumulator, grad, lr, l1, l2, globalStep, options);
    }

    public <T extends TType> ResourceApplyAdam resourceApplyAdam(Operand<?> var, Operand<?> m, Operand<?> v, Operand<T> beta1Power, Operand<T> beta2Power, Operand<T> lr, Operand<T> beta1, Operand<T> beta2, Operand<T> epsilon, Operand<T> grad, ResourceApplyAdam.Options ... options) {
        return ResourceApplyAdam.create(this.scope, var, m, v, beta1Power, beta2Power, lr, beta1, beta2, epsilon, grad, options);
    }

    public <T extends TType> ResourceApplyAdamWithAmsgrad resourceApplyAdamWithAmsgrad(Operand<?> var, Operand<?> m, Operand<?> v, Operand<?> vhat, Operand<T> beta1Power, Operand<T> beta2Power, Operand<T> lr, Operand<T> beta1, Operand<T> beta2, Operand<T> epsilon, Operand<T> grad, ResourceApplyAdamWithAmsgrad.Options ... options) {
        return ResourceApplyAdamWithAmsgrad.create(this.scope, var, m, v, vhat, beta1Power, beta2Power, lr, beta1, beta2, epsilon, grad, options);
    }

    public <T extends TType> ResourceApplyAddSign resourceApplyAddSign(Operand<?> var, Operand<?> m, Operand<T> lr, Operand<T> alpha, Operand<T> signDecay, Operand<T> beta, Operand<T> grad, ResourceApplyAddSign.Options ... options) {
        return ResourceApplyAddSign.create(this.scope, var, m, lr, alpha, signDecay, beta, grad, options);
    }

    public <T extends TType> ResourceApplyCenteredRmsProp resourceApplyCenteredRmsProp(Operand<?> var, Operand<?> mg, Operand<?> ms, Operand<?> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, ResourceApplyCenteredRmsProp.Options ... options) {
        return ResourceApplyCenteredRmsProp.create(this.scope, var, mg, ms, mom, lr, rho, momentum, epsilon, grad, options);
    }

    public <T extends TType> ResourceApplyFtrl resourceApplyFtrl(Operand<?> var, Operand<?> accum, Operand<?> linear, Operand<T> grad, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> l2Shrinkage, Operand<T> lrPower, ResourceApplyFtrl.Options ... options) {
        return ResourceApplyFtrl.create(this.scope, var, accum, linear, grad, lr, l1, l2, l2Shrinkage, lrPower, options);
    }

    public <T extends TType> ResourceApplyGradientDescent resourceApplyGradientDescent(Operand<?> var, Operand<T> alpha, Operand<T> delta, ResourceApplyGradientDescent.Options ... options) {
        return ResourceApplyGradientDescent.create(this.scope, var, alpha, delta, options);
    }

    public <T extends TType> ResourceApplyKerasMomentum resourceApplyKerasMomentum(Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<T> momentum, ResourceApplyKerasMomentum.Options ... options) {
        return ResourceApplyKerasMomentum.create(this.scope, var, accum, lr, grad, momentum, options);
    }

    public <T extends TType> ResourceApplyMomentum resourceApplyMomentum(Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<T> momentum, ResourceApplyMomentum.Options ... options) {
        return ResourceApplyMomentum.create(this.scope, var, accum, lr, grad, momentum, options);
    }

    public <T extends TType> ResourceApplyPowerSign resourceApplyPowerSign(Operand<?> var, Operand<?> m, Operand<T> lr, Operand<T> logbase, Operand<T> signDecay, Operand<T> beta, Operand<T> grad, ResourceApplyPowerSign.Options ... options) {
        return ResourceApplyPowerSign.create(this.scope, var, m, lr, logbase, signDecay, beta, grad, options);
    }

    public <T extends TType> ResourceApplyProximalAdagrad resourceApplyProximalAdagrad(Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> grad, ResourceApplyProximalAdagrad.Options ... options) {
        return ResourceApplyProximalAdagrad.create(this.scope, var, accum, lr, l1, l2, grad, options);
    }

    public <T extends TType> ResourceApplyProximalGradientDescent resourceApplyProximalGradientDescent(Operand<?> var, Operand<T> alpha, Operand<T> l1, Operand<T> l2, Operand<T> delta, ResourceApplyProximalGradientDescent.Options ... options) {
        return ResourceApplyProximalGradientDescent.create(this.scope, var, alpha, l1, l2, delta, options);
    }

    public <T extends TType> ResourceApplyRmsProp resourceApplyRmsProp(Operand<?> var, Operand<?> ms, Operand<?> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, ResourceApplyRmsProp.Options ... options) {
        return ResourceApplyRmsProp.create(this.scope, var, ms, mom, lr, rho, momentum, epsilon, grad, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyAdadelta resourceSparseApplyAdadelta(Operand<?> var, Operand<?> accum, Operand<?> accumUpdate, Operand<T> lr, Operand<T> rho, Operand<T> epsilon, Operand<T> grad, Operand<U> indices, ResourceSparseApplyAdadelta.Options ... options) {
        return ResourceSparseApplyAdadelta.create(this.scope, var, accum, accumUpdate, lr, rho, epsilon, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyAdagrad resourceSparseApplyAdagrad(Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, ResourceSparseApplyAdagrad.Options ... options) {
        return ResourceSparseApplyAdagrad.create(this.scope, var, accum, lr, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyAdagradDa resourceSparseApplyAdagradDa(Operand<?> var, Operand<?> gradientAccumulator, Operand<?> gradientSquaredAccumulator, Operand<T> grad, Operand<U> indices, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<TInt64> globalStep, ResourceSparseApplyAdagradDa.Options ... options) {
        return ResourceSparseApplyAdagradDa.create(this.scope, var, gradientAccumulator, gradientSquaredAccumulator, grad, indices, lr, l1, l2, globalStep, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyCenteredRmsProp resourceSparseApplyCenteredRmsProp(Operand<?> var, Operand<?> mg, Operand<?> ms, Operand<?> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, Operand<U> indices, ResourceSparseApplyCenteredRmsProp.Options ... options) {
        return ResourceSparseApplyCenteredRmsProp.create(this.scope, var, mg, ms, mom, lr, rho, momentum, epsilon, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyFtrl resourceSparseApplyFtrl(Operand<?> var, Operand<?> accum, Operand<?> linear, Operand<T> grad, Operand<U> indices, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> l2Shrinkage, Operand<T> lrPower, ResourceSparseApplyFtrl.Options ... options) {
        return ResourceSparseApplyFtrl.create(this.scope, var, accum, linear, grad, indices, lr, l1, l2, l2Shrinkage, lrPower, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyKerasMomentum resourceSparseApplyKerasMomentum(Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum, ResourceSparseApplyKerasMomentum.Options ... options) {
        return ResourceSparseApplyKerasMomentum.create(this.scope, var, accum, lr, grad, indices, momentum, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyMomentum resourceSparseApplyMomentum(Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum, ResourceSparseApplyMomentum.Options ... options) {
        return ResourceSparseApplyMomentum.create(this.scope, var, accum, lr, grad, indices, momentum, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyProximalAdagrad resourceSparseApplyProximalAdagrad(Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> grad, Operand<U> indices, ResourceSparseApplyProximalAdagrad.Options ... options) {
        return ResourceSparseApplyProximalAdagrad.create(this.scope, var, accum, lr, l1, l2, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyProximalGradientDescent resourceSparseApplyProximalGradientDescent(Operand<?> var, Operand<T> alpha, Operand<T> l1, Operand<T> l2, Operand<T> grad, Operand<U> indices, ResourceSparseApplyProximalGradientDescent.Options ... options) {
        return ResourceSparseApplyProximalGradientDescent.create(this.scope, var, alpha, l1, l2, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> ResourceSparseApplyRmsProp resourceSparseApplyRmsProp(Operand<?> var, Operand<?> ms, Operand<?> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, Operand<U> indices, ResourceSparseApplyRmsProp.Options ... options) {
        return ResourceSparseApplyRmsProp.create(this.scope, var, ms, mom, lr, rho, momentum, epsilon, grad, indices, options);
    }

    public Restore restore(Operand<TString> prefix, Operand<TString> tensorNames, Operand<TString> shapeAndSlices, List<DataType<?>> dtypes) {
        return Restore.create(this.scope, prefix, tensorNames, shapeAndSlices, dtypes);
    }

    public <T extends TType> RestoreSlice<T> restoreSlice(Operand<TString> filePattern, Operand<TString> tensorName, Operand<TString> shapeAndSlice, DataType<T> dt, RestoreSlice.Options ... options) {
        return RestoreSlice.create(this.scope, filePattern, tensorName, shapeAndSlice, dt, options);
    }

    public Save save(Operand<TString> prefix, Operand<TString> tensorNames, Operand<TString> shapeAndSlices, Iterable<Operand<?>> tensors) {
        return Save.create(this.scope, prefix, tensorNames, shapeAndSlices, tensors);
    }

    public SaveSlices saveSlices(Operand<TString> filename, Operand<TString> tensorNames, Operand<TString> shapesAndSlices, Iterable<Operand<?>> data) {
        return SaveSlices.create(this.scope, filename, tensorNames, shapesAndSlices, data);
    }

    public SdcaFprint sdcaFprint(Operand<TString> input) {
        return SdcaFprint.create(this.scope, input);
    }

    public SdcaShrinkL1 sdcaShrinkL1(Iterable<Operand<TFloat32>> weights, Float l1, Float l2) {
        return SdcaShrinkL1.create(this.scope, weights, l1, l2);
    }

    public <T extends TType, U extends TNumber> SparseApplyAdadelta<T> sparseApplyAdadelta(Operand<T> var, Operand<T> accum, Operand<T> accumUpdate, Operand<T> lr, Operand<T> rho, Operand<T> epsilon, Operand<T> grad, Operand<U> indices, SparseApplyAdadelta.Options ... options) {
        return SparseApplyAdadelta.create(this.scope, var, accum, accumUpdate, lr, rho, epsilon, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> SparseApplyAdagradDa<T> sparseApplyAdagradDa(Operand<T> var, Operand<T> gradientAccumulator, Operand<T> gradientSquaredAccumulator, Operand<T> grad, Operand<U> indices, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<TInt64> globalStep, SparseApplyAdagradDa.Options ... options) {
        return SparseApplyAdagradDa.create(this.scope, var, gradientAccumulator, gradientSquaredAccumulator, grad, indices, lr, l1, l2, globalStep, options);
    }

    public <T extends TType, U extends TNumber> SparseApplyCenteredRmsProp<T> sparseApplyCenteredRmsProp(Operand<T> var, Operand<T> mg, Operand<T> ms, Operand<T> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, Operand<U> indices, SparseApplyCenteredRmsProp.Options ... options) {
        return SparseApplyCenteredRmsProp.create(this.scope, var, mg, ms, mom, lr, rho, momentum, epsilon, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> SparseApplyFtrl<T> sparseApplyFtrl(Operand<T> var, Operand<T> accum, Operand<T> linear, Operand<T> grad, Operand<U> indices, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> l2Shrinkage, Operand<T> lrPower, SparseApplyFtrl.Options ... options) {
        return SparseApplyFtrl.create(this.scope, var, accum, linear, grad, indices, lr, l1, l2, l2Shrinkage, lrPower, options);
    }

    public <T extends TType, U extends TNumber> SparseApplyMomentum<T> sparseApplyMomentum(Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum, SparseApplyMomentum.Options ... options) {
        return SparseApplyMomentum.create(this.scope, var, accum, lr, grad, indices, momentum, options);
    }

    public <T extends TType, U extends TNumber> SparseApplyProximalAdagrad<T> sparseApplyProximalAdagrad(Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> l1, Operand<T> l2, Operand<T> grad, Operand<U> indices, SparseApplyProximalAdagrad.Options ... options) {
        return SparseApplyProximalAdagrad.create(this.scope, var, accum, lr, l1, l2, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> SparseApplyProximalGradientDescent<T> sparseApplyProximalGradientDescent(Operand<T> var, Operand<T> alpha, Operand<T> l1, Operand<T> l2, Operand<T> grad, Operand<U> indices, SparseApplyProximalGradientDescent.Options ... options) {
        return SparseApplyProximalGradientDescent.create(this.scope, var, alpha, l1, l2, grad, indices, options);
    }

    public <T extends TType, U extends TNumber> SparseApplyRmsProp<T> sparseApplyRmsProp(Operand<T> var, Operand<T> ms, Operand<T> mom, Operand<T> lr, Operand<T> rho, Operand<T> momentum, Operand<T> epsilon, Operand<T> grad, Operand<U> indices, SparseApplyRmsProp.Options ... options) {
        return SparseApplyRmsProp.create(this.scope, var, ms, mom, lr, rho, momentum, epsilon, grad, indices, options);
    }

    public <T extends TType> TileGrad<T> tileGrad(Operand<T> input, Operand<TInt32> multiples) {
        return TileGrad.create(this.scope, input, multiples);
    }
}

