/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Shape;
import org.tensorflow.op.core.Shapes;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class ShapeOps {
    private final Scope scope;

    ShapeOps(Scope scope) {
        this.scope = scope;
    }

    public Operand<TInt64> append(Shape<TInt64> shape, long lastDimension) {
        return Shapes.append(this.scope, shape, lastDimension);
    }

    public Operand<TInt32> append(Shape<TInt32> shape, int lastDimension) {
        return Shapes.append(this.scope, shape, lastDimension);
    }

    public <T extends TNumber> Operand<T> append(Operand<T> shape, Operand<T> shapeToAppend) {
        return Shapes.append(this.scope, shape, shapeToAppend);
    }

    public <T extends TType> Operand<T> flatten(Operand<T> operand) {
        return Shapes.flatten(this.scope, operand);
    }

    public Operand<TInt32> flatten(Shape<TInt32> shape) {
        return Shapes.flatten(this.scope, shape);
    }

    public <T extends TType, U extends TNumber> Operand<T> flatten(Operand<T> operand, DataType<U> dType) {
        return Shapes.flatten(this.scope, operand, dType);
    }

    public <U extends TNumber> Operand<U> flatten(Shape<U> shape, DataType<U> dType) {
        return Shapes.flatten(this.scope, shape, dType);
    }

    public Operand<TInt32> head(Shape<TInt32> shape) {
        return Shapes.head(this.scope, shape);
    }

    public <U extends TNumber> Operand<U> head(Shape<U> shape, DataType<U> dType) {
        return Shapes.head(this.scope, shape, dType);
    }

    public Operand<TInt32> numDimensions(Shape<TInt32> shape) {
        return Shapes.numDimensions(this.scope, shape);
    }

    public <U extends TNumber> Operand<U> numDimensions(Shape<U> shape, DataType<U> dType) {
        return Shapes.numDimensions(this.scope, shape, dType);
    }

    public Operand<TInt64> prepend(Shape<TInt64> shape, long firstDimension) {
        return Shapes.prepend(this.scope, shape, firstDimension);
    }

    public Operand<TInt32> prepend(Shape<TInt32> shape, int firstDimension) {
        return Shapes.prepend(this.scope, shape, firstDimension);
    }

    public <T extends TNumber> Operand<T> prepend(Operand<T> shape, Operand<T> shapeToPrepend) {
        return Shapes.prepend(this.scope, shape, shapeToPrepend);
    }

    public <T extends TType> Operand<T> reduceDims(Operand<T> operand, Operand<TInt32> axis) {
        return Shapes.reduceDims(this.scope, operand, axis);
    }

    public Operand<TInt32> reduceDims(Shape<TInt32> shape, Operand<TInt32> axis) {
        return Shapes.reduceDims(this.scope, shape, axis);
    }

    public <T extends TType, U extends TNumber> Operand<T> reduceDims(Operand<T> operand, Operand<U> axis, DataType<U> dType) {
        return Shapes.reduceDims(this.scope, operand, axis, dType);
    }

    public <U extends TNumber> Operand<U> reduceDims(Shape<U> shape, Operand<U> axis, DataType<U> dType) {
        return Shapes.reduceDims(this.scope, shape, axis, dType);
    }

    public Operand<TInt32> size(Shape<TInt32> shape) {
        return Shapes.size(this.scope, shape);
    }

    public <T extends TType> Operand<TInt32> size(Operand<T> input, Operand<TInt32> dim) {
        return Shapes.size(this.scope, input, dim);
    }

    public <U extends TNumber> Operand<U> size(Shape<U> shape, DataType<U> dType) {
        return Shapes.size(this.scope, shape, dType);
    }

    public Operand<TInt32> size(Shape<TInt32> shape, Operand<TInt32> dim) {
        return Shapes.size(this.scope, shape, dim);
    }

    public <T extends TType, U extends TNumber> Operand<U> size(Operand<T> input, Operand<U> dim, DataType<U> dType) {
        return Shapes.size(this.scope, input, dim, dType);
    }

    public <U extends TNumber> Operand<U> size(Shape<U> shape, Operand<U> dim, DataType<U> dType) {
        return Shapes.size(this.scope, shape, dim, dType);
    }

    public Operand<TInt32> squeeze(Shape<TInt32> shape) {
        return Shapes.squeeze(this.scope, shape);
    }

    public <U extends TNumber> Operand<U> squeeze(Shape<U> shape, DataType<U> dType) {
        return Shapes.squeeze(this.scope, shape, dType);
    }

    public Operand<TInt32> tail(Shape<TInt32> shape) {
        return Shapes.tail(this.scope, shape);
    }

    public <U extends TNumber> Operand<U> tail(Shape<U> shape, DataType<U> dType) {
        return Shapes.tail(this.scope, shape, dType);
    }

    public Operand<TInt32> take(Shape<TInt32> shape, Operand<TInt32> n) {
        return Shapes.take(this.scope, shape, n);
    }

    public <U extends TNumber> Operand<U> take(Shape<U> shape, Operand<U> n, DataType<U> dType) {
        return Shapes.take(this.scope, shape, n, dType);
    }

    public <U extends TNumber> Operand<TInt32> takeLast(Shape<TInt32> shape, Operand<TInt32> n) {
        return Shapes.takeLast(this.scope, shape, n);
    }

    public <U extends TNumber> Operand<U> takeLast(Shape<U> shape, Operand<U> n, DataType<U> dType) {
        return Shapes.takeLast(this.scope, shape, n, dType);
    }
}

