/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.op.NnRawOps;
import org.tensorflow.op.Scope;
import org.tensorflow.op.nn.AvgPool;
import org.tensorflow.op.nn.AvgPool3d;
import org.tensorflow.op.nn.AvgPool3dGrad;
import org.tensorflow.op.nn.BatchNormWithGlobalNormalization;
import org.tensorflow.op.nn.BatchNormWithGlobalNormalizationGrad;
import org.tensorflow.op.nn.BiasAdd;
import org.tensorflow.op.nn.BiasAddGrad;
import org.tensorflow.op.nn.ComputeAccidentalHits;
import org.tensorflow.op.nn.Conv2d;
import org.tensorflow.op.nn.Conv2dBackpropFilter;
import org.tensorflow.op.nn.Conv2dBackpropInput;
import org.tensorflow.op.nn.Conv3d;
import org.tensorflow.op.nn.Conv3dBackpropFilter;
import org.tensorflow.op.nn.Conv3dBackpropInput;
import org.tensorflow.op.nn.CtcBeamSearchDecoder;
import org.tensorflow.op.nn.CtcGreedyDecoder;
import org.tensorflow.op.nn.CtcLoss;
import org.tensorflow.op.nn.CudnnRNNCanonicalToParams;
import org.tensorflow.op.nn.CudnnRNNParamsToCanonical;
import org.tensorflow.op.nn.CudnnRnnParamsSize;
import org.tensorflow.op.nn.DataFormatDimMap;
import org.tensorflow.op.nn.DataFormatVecPermute;
import org.tensorflow.op.nn.DepthToSpace;
import org.tensorflow.op.nn.DepthwiseConv2dNative;
import org.tensorflow.op.nn.DepthwiseConv2dNativeBackpropFilter;
import org.tensorflow.op.nn.DepthwiseConv2dNativeBackpropInput;
import org.tensorflow.op.nn.Dilation2d;
import org.tensorflow.op.nn.Dilation2dBackpropFilter;
import org.tensorflow.op.nn.Dilation2dBackpropInput;
import org.tensorflow.op.nn.Elu;
import org.tensorflow.op.nn.FixedUnigramCandidateSampler;
import org.tensorflow.op.nn.FractionalAvgPool;
import org.tensorflow.op.nn.FractionalMaxPool;
import org.tensorflow.op.nn.FusedBatchNorm;
import org.tensorflow.op.nn.FusedBatchNormGrad;
import org.tensorflow.op.nn.FusedPadConv2d;
import org.tensorflow.op.nn.FusedResizeAndPadConv2d;
import org.tensorflow.op.nn.InTopK;
import org.tensorflow.op.nn.L2Loss;
import org.tensorflow.op.nn.LearnedUnigramCandidateSampler;
import org.tensorflow.op.nn.LocalResponseNormalization;
import org.tensorflow.op.nn.LogSoftmax;
import org.tensorflow.op.nn.MaxPool;
import org.tensorflow.op.nn.MaxPool3d;
import org.tensorflow.op.nn.MaxPool3dGrad;
import org.tensorflow.op.nn.MaxPool3dGradGrad;
import org.tensorflow.op.nn.MaxPoolGrad;
import org.tensorflow.op.nn.MaxPoolGradGrad;
import org.tensorflow.op.nn.MaxPoolGradGradWithArgmax;
import org.tensorflow.op.nn.MaxPoolWithArgmax;
import org.tensorflow.op.nn.NthElement;
import org.tensorflow.op.nn.QuantizedAvgPool;
import org.tensorflow.op.nn.QuantizedBatchNormWithGlobalNormalization;
import org.tensorflow.op.nn.QuantizedBiasAdd;
import org.tensorflow.op.nn.QuantizedConv2d;
import org.tensorflow.op.nn.QuantizedInstanceNorm;
import org.tensorflow.op.nn.QuantizedMaxPool;
import org.tensorflow.op.nn.QuantizedRelu;
import org.tensorflow.op.nn.QuantizedRelu6;
import org.tensorflow.op.nn.QuantizedReluX;
import org.tensorflow.op.nn.Relu;
import org.tensorflow.op.nn.Relu6;
import org.tensorflow.op.nn.Selu;
import org.tensorflow.op.nn.SigmoidCrossEntropyWithLogits;
import org.tensorflow.op.nn.Softmax;
import org.tensorflow.op.nn.SoftmaxCrossEntropyWithLogits;
import org.tensorflow.op.nn.Softsign;
import org.tensorflow.op.nn.SpaceToBatch;
import org.tensorflow.op.nn.SpaceToDepth;
import org.tensorflow.op.nn.SparseSoftmaxCrossEntropyWithLogits;
import org.tensorflow.op.nn.TopK;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class NnOps {
    public final NnRawOps raw;
    private final Scope scope;

    NnOps(Scope scope) {
        this.scope = scope;
        this.raw = new NnRawOps(scope);
    }

    public <T extends TNumber> AvgPool<T> avgPool(Operand<T> value, List<Long> ksize, List<Long> strides, String padding, AvgPool.Options ... options) {
        return AvgPool.create(this.scope, value, ksize, strides, padding, options);
    }

    public <T extends TNumber> AvgPool3d<T> avgPool3d(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, AvgPool3d.Options ... options) {
        return AvgPool3d.create(this.scope, input, ksize, strides, padding, options);
    }

    public <T extends TNumber> AvgPool3dGrad<T> avgPool3dGrad(Operand<TInt32> origInputShape, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, AvgPool3dGrad.Options ... options) {
        return AvgPool3dGrad.create(this.scope, origInputShape, grad, ksize, strides, padding, options);
    }

    public <T extends TType> BatchNormWithGlobalNormalization<T> batchNormWithGlobalNormalization(Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> beta, Operand<T> gamma, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return BatchNormWithGlobalNormalization.create(this.scope, t, m, v, beta, gamma, varianceEpsilon, scaleAfterNormalization);
    }

    public <T extends TType> BatchNormWithGlobalNormalizationGrad<T> batchNormWithGlobalNormalizationGrad(Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> gamma, Operand<T> backprop, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return BatchNormWithGlobalNormalizationGrad.create(this.scope, t, m, v, gamma, backprop, varianceEpsilon, scaleAfterNormalization);
    }

    public <T extends TType> BiasAdd<T> biasAdd(Operand<T> value, Operand<T> bias, BiasAdd.Options ... options) {
        return BiasAdd.create(this.scope, value, bias, options);
    }

    public <T extends TType> BiasAddGrad<T> biasAddGrad(Operand<T> outBackprop, BiasAddGrad.Options ... options) {
        return BiasAddGrad.create(this.scope, outBackprop, options);
    }

    public ComputeAccidentalHits computeAccidentalHits(Operand<TInt64> trueClasses, Operand<TInt64> sampledCandidates, Long numTrue, ComputeAccidentalHits.Options ... options) {
        return ComputeAccidentalHits.create(this.scope, trueClasses, sampledCandidates, numTrue, options);
    }

    public <T extends TNumber> Conv2d<T> conv2d(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, Conv2d.Options ... options) {
        return Conv2d.create(this.scope, input, filter, strides, padding, options);
    }

    public <T extends TNumber> Conv2dBackpropFilter<T> conv2dBackpropFilter(Operand<T> input, Operand<TInt32> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, Conv2dBackpropFilter.Options ... options) {
        return Conv2dBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> Conv2dBackpropInput<T> conv2dBackpropInput(Operand<TInt32> inputSizes, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding, Conv2dBackpropInput.Options ... options) {
        return Conv2dBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> Conv3d<T> conv3d(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, Conv3d.Options ... options) {
        return Conv3d.create(this.scope, input, filter, strides, padding, options);
    }

    public <T extends TNumber> Conv3dBackpropFilter<T> conv3dBackpropFilter(Operand<T> input, Operand<TInt32> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, Conv3dBackpropFilter.Options ... options) {
        return Conv3dBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }

    public <U extends TNumber, T extends TNumber> Conv3dBackpropInput<U> conv3dBackpropInput(Operand<T> inputSizes, Operand<U> filter, Operand<U> outBackprop, List<Long> strides, String padding, Conv3dBackpropInput.Options ... options) {
        return Conv3dBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> CtcBeamSearchDecoder<T> ctcBeamSearchDecoder(Operand<T> inputs, Operand<TInt32> sequenceLength, Long beamWidth, Long topPaths, CtcBeamSearchDecoder.Options ... options) {
        return CtcBeamSearchDecoder.create(this.scope, inputs, sequenceLength, beamWidth, topPaths, options);
    }

    public <T extends TNumber> CtcGreedyDecoder<T> ctcGreedyDecoder(Operand<T> inputs, Operand<TInt32> sequenceLength, CtcGreedyDecoder.Options ... options) {
        return CtcGreedyDecoder.create(this.scope, inputs, sequenceLength, options);
    }

    public <T extends TNumber> CtcLoss<T> ctcLoss(Operand<T> inputs, Operand<TInt64> labelsIndices, Operand<TInt32> labelsValues, Operand<TInt32> sequenceLength, CtcLoss.Options ... options) {
        return CtcLoss.create(this.scope, inputs, labelsIndices, labelsValues, sequenceLength, options);
    }

    public <T extends TNumber> CudnnRNNCanonicalToParams<T> cudnnRNNCanonicalToParams(Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, Iterable<Operand<T>> weights, Iterable<Operand<T>> biases, CudnnRNNCanonicalToParams.Options ... options) {
        return CudnnRNNCanonicalToParams.create(this.scope, numLayers, numUnits, inputSize, weights, biases, options);
    }

    public <T extends TNumber> CudnnRNNParamsToCanonical<T> cudnnRNNParamsToCanonical(Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, Operand<T> params, Long numParamsWeights, Long numParamsBiases, CudnnRNNParamsToCanonical.Options ... options) {
        return CudnnRNNParamsToCanonical.create(this.scope, numLayers, numUnits, inputSize, params, numParamsWeights, numParamsBiases, options);
    }

    public <U extends TNumber, T extends TNumber> CudnnRnnParamsSize<U> cudnnRnnParamsSize(Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, DataType<T> T, DataType<U> S, CudnnRnnParamsSize.Options ... options) {
        return CudnnRnnParamsSize.create(this.scope, numLayers, numUnits, inputSize, T, S, options);
    }

    public <T extends TNumber> DataFormatDimMap<T> dataFormatDimMap(Operand<T> x, DataFormatDimMap.Options ... options) {
        return DataFormatDimMap.create(this.scope, x, options);
    }

    public <T extends TNumber> DataFormatVecPermute<T> dataFormatVecPermute(Operand<T> x, DataFormatVecPermute.Options ... options) {
        return DataFormatVecPermute.create(this.scope, x, options);
    }

    public <T extends TType> DepthToSpace<T> depthToSpace(Operand<T> input, Long blockSize, DepthToSpace.Options ... options) {
        return DepthToSpace.create(this.scope, input, blockSize, options);
    }

    public <T extends TNumber> DepthwiseConv2dNative<T> depthwiseConv2dNative(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, DepthwiseConv2dNative.Options ... options) {
        return DepthwiseConv2dNative.create(this.scope, input, filter, strides, padding, options);
    }

    public <T extends TNumber> DepthwiseConv2dNativeBackpropFilter<T> depthwiseConv2dNativeBackpropFilter(Operand<T> input, Operand<TInt32> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, DepthwiseConv2dNativeBackpropFilter.Options ... options) {
        return DepthwiseConv2dNativeBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> DepthwiseConv2dNativeBackpropInput<T> depthwiseConv2dNativeBackpropInput(Operand<TInt32> inputSizes, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding, DepthwiseConv2dNativeBackpropInput.Options ... options) {
        return DepthwiseConv2dNativeBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public <T extends TNumber> Dilation2d<T> dilation2d(Operand<T> input, Operand<T> filter, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2d.create(this.scope, input, filter, strides, rates, padding);
    }

    public <T extends TNumber> Dilation2dBackpropFilter<T> dilation2dBackpropFilter(Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2dBackpropFilter.create(this.scope, input, filter, outBackprop, strides, rates, padding);
    }

    public <T extends TNumber> Dilation2dBackpropInput<T> dilation2dBackpropInput(Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2dBackpropInput.create(this.scope, input, filter, outBackprop, strides, rates, padding);
    }

    public <T extends TNumber> Elu<T> elu(Operand<T> features) {
        return Elu.create(this.scope, features);
    }

    public FixedUnigramCandidateSampler fixedUnigramCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, FixedUnigramCandidateSampler.Options ... options) {
        return FixedUnigramCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <T extends TNumber> FractionalAvgPool<T> fractionalAvgPool(Operand<T> value, List<Float> poolingRatio, FractionalAvgPool.Options ... options) {
        return FractionalAvgPool.create(this.scope, value, poolingRatio, options);
    }

    public <T extends TNumber> FractionalMaxPool<T> fractionalMaxPool(Operand<T> value, List<Float> poolingRatio, FractionalMaxPool.Options ... options) {
        return FractionalMaxPool.create(this.scope, value, poolingRatio, options);
    }

    public <T extends TNumber, U extends TNumber> FusedBatchNorm<T, U> fusedBatchNorm(Operand<T> x, Operand<U> scale, Operand<U> offset, Operand<U> mean, Operand<U> variance, FusedBatchNorm.Options ... options) {
        return FusedBatchNorm.create(this.scope, x, scale, offset, mean, variance, options);
    }

    public <T extends TNumber, U extends TNumber> FusedBatchNormGrad<T, U> fusedBatchNormGrad(Operand<T> yBackprop, Operand<T> x, Operand<TFloat32> scale, Operand<U> reserveSpace1, Operand<U> reserveSpace2, Operand<U> reserveSpace3, FusedBatchNormGrad.Options ... options) {
        return FusedBatchNormGrad.create(this.scope, yBackprop, x, scale, reserveSpace1, reserveSpace2, reserveSpace3, options);
    }

    public <T extends TNumber> FusedPadConv2d<T> fusedPadConv2d(Operand<T> input, Operand<TInt32> paddings, Operand<T> filter, String mode, List<Long> strides, String padding) {
        return FusedPadConv2d.create(this.scope, input, paddings, filter, mode, strides, padding);
    }

    public <T extends TNumber> FusedResizeAndPadConv2d<T> fusedResizeAndPadConv2d(Operand<T> input, Operand<TInt32> size, Operand<TInt32> paddings, Operand<T> filter, String mode, List<Long> strides, String padding, FusedResizeAndPadConv2d.Options ... options) {
        return FusedResizeAndPadConv2d.create(this.scope, input, size, paddings, filter, mode, strides, padding, options);
    }

    public <T extends TNumber> InTopK inTopK(Operand<TFloat32> predictions, Operand<T> targets, Operand<T> k) {
        return InTopK.create(this.scope, predictions, targets, k);
    }

    public <T extends TNumber> L2Loss<T> l2Loss(Operand<T> t) {
        return L2Loss.create(this.scope, t);
    }

    public LearnedUnigramCandidateSampler learnedUnigramCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, LearnedUnigramCandidateSampler.Options ... options) {
        return LearnedUnigramCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <T extends TNumber> LocalResponseNormalization<T> localResponseNormalization(Operand<T> input, LocalResponseNormalization.Options ... options) {
        return LocalResponseNormalization.create(this.scope, input, options);
    }

    public <T extends TNumber> LogSoftmax<T> logSoftmax(Operand<T> logits) {
        return LogSoftmax.create(this.scope, logits);
    }

    public <T extends TType> MaxPool<T> maxPool(Operand<T> input, Operand<TInt32> ksize, Operand<TInt32> strides, String padding, MaxPool.Options ... options) {
        return MaxPool.create(this.scope, input, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPool3d<T> maxPool3d(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, MaxPool3d.Options ... options) {
        return MaxPool3d.create(this.scope, input, ksize, strides, padding, options);
    }

    public <U extends TNumber, T extends TNumber> MaxPool3dGrad<U> maxPool3dGrad(Operand<T> origInput, Operand<T> origOutput, Operand<U> grad, List<Long> ksize, List<Long> strides, String padding, MaxPool3dGrad.Options ... options) {
        return MaxPool3dGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPool3dGradGrad<T> maxPool3dGradGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, MaxPool3dGradGrad.Options ... options) {
        return MaxPool3dGradGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPoolGrad<T> maxPoolGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, Operand<TInt32> ksize, Operand<TInt32> strides, String padding, MaxPoolGrad.Options ... options) {
        return MaxPoolGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPoolGradGrad<T> maxPoolGradGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, Operand<TInt32> ksize, Operand<TInt32> strides, String padding, MaxPoolGradGrad.Options ... options) {
        return MaxPoolGradGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends TNumber, U extends TNumber> MaxPoolGradGradWithArgmax<T> maxPoolGradGradWithArgmax(Operand<T> input, Operand<T> grad, Operand<U> argmax, List<Long> ksize, List<Long> strides, String padding, MaxPoolGradGradWithArgmax.Options ... options) {
        return MaxPoolGradGradWithArgmax.create(this.scope, input, grad, argmax, ksize, strides, padding, options);
    }

    public <T extends TNumber> MaxPoolWithArgmax<T, TInt64> maxPoolWithArgmax(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, MaxPoolWithArgmax.Options ... options) {
        return MaxPoolWithArgmax.create(this.scope, input, ksize, strides, padding, options);
    }

    public <T extends TNumber, U extends TNumber> MaxPoolWithArgmax<T, U> maxPoolWithArgmax(Operand<T> input, List<Long> ksize, List<Long> strides, DataType<U> Targmax, String padding, MaxPoolWithArgmax.Options ... options) {
        return MaxPoolWithArgmax.create(this.scope, input, ksize, strides, Targmax, padding, options);
    }

    public <T extends TNumber> NthElement<T> nthElement(Operand<T> input, Operand<TInt32> n, NthElement.Options ... options) {
        return NthElement.create(this.scope, input, n, options);
    }

    public <T extends TType> QuantizedAvgPool<T> quantizedAvgPool(Operand<T> input, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, List<Long> ksize, List<Long> strides, String padding) {
        return QuantizedAvgPool.create(this.scope, input, minInput, maxInput, ksize, strides, padding);
    }

    public <U extends TType, T extends TType> QuantizedBatchNormWithGlobalNormalization<U> quantizedBatchNormWithGlobalNormalization(Operand<T> t, Operand<TFloat32> tMin, Operand<TFloat32> tMax, Operand<T> m, Operand<TFloat32> mMin, Operand<TFloat32> mMax, Operand<T> v, Operand<TFloat32> vMin, Operand<TFloat32> vMax, Operand<T> beta, Operand<TFloat32> betaMin, Operand<TFloat32> betaMax, Operand<T> gamma, Operand<TFloat32> gammaMin, Operand<TFloat32> gammaMax, DataType<U> outType, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return QuantizedBatchNormWithGlobalNormalization.create(this.scope, t, tMin, tMax, m, mMin, mMax, v, vMin, vMax, beta, betaMin, betaMax, gamma, gammaMin, gammaMax, outType, varianceEpsilon, scaleAfterNormalization);
    }

    public <V extends TType, T extends TType, U extends TType> QuantizedBiasAdd<V> quantizedBiasAdd(Operand<T> input, Operand<U> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minBias, Operand<TFloat32> maxBias, DataType<V> outType) {
        return QuantizedBiasAdd.create(this.scope, input, bias, minInput, maxInput, minBias, maxBias, outType);
    }

    public <V extends TType, T extends TType, U extends TType> QuantizedConv2d<V> quantizedConv2d(Operand<T> input, Operand<U> filter, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, DataType<V> outType, List<Long> strides, String padding, QuantizedConv2d.Options ... options) {
        return QuantizedConv2d.create(this.scope, input, filter, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <T extends TType> QuantizedInstanceNorm<T> quantizedInstanceNorm(Operand<T> x, Operand<TFloat32> xMin, Operand<TFloat32> xMax, QuantizedInstanceNorm.Options ... options) {
        return QuantizedInstanceNorm.create(this.scope, x, xMin, xMax, options);
    }

    public <T extends TType> QuantizedMaxPool<T> quantizedMaxPool(Operand<T> input, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, List<Long> ksize, List<Long> strides, String padding) {
        return QuantizedMaxPool.create(this.scope, input, minInput, maxInput, ksize, strides, padding);
    }

    public <U extends TType, T extends TType> QuantizedRelu<U> quantizedRelu(Operand<T> features, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, DataType<U> outType) {
        return QuantizedRelu.create(this.scope, features, minFeatures, maxFeatures, outType);
    }

    public <U extends TType, T extends TType> QuantizedRelu6<U> quantizedRelu6(Operand<T> features, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, DataType<U> outType) {
        return QuantizedRelu6.create(this.scope, features, minFeatures, maxFeatures, outType);
    }

    public <U extends TType, T extends TType> QuantizedReluX<U> quantizedReluX(Operand<T> features, Operand<TFloat32> maxValue, Operand<TFloat32> minFeatures, Operand<TFloat32> maxFeatures, DataType<U> outType) {
        return QuantizedReluX.create(this.scope, features, maxValue, minFeatures, maxFeatures, outType);
    }

    public <T extends TType> Relu<T> relu(Operand<T> features) {
        return Relu.create(this.scope, features);
    }

    public <T extends TNumber> Relu6<T> relu6(Operand<T> features) {
        return Relu6.create(this.scope, features);
    }

    public <T extends TNumber> Selu<T> selu(Operand<T> features) {
        return Selu.create(this.scope, features);
    }

    public <T extends TNumber> Operand<T> sigmoidCrossEntropyWithLogits(Operand<T> labels, Operand<T> logits) {
        return SigmoidCrossEntropyWithLogits.sigmoidCrossEntropyWithLogits(this.scope, labels, logits);
    }

    public <T extends TNumber> Softmax<T> softmax(Operand<T> logits) {
        return Softmax.create(this.scope, logits);
    }

    public <T extends TNumber, U extends TNumber> Operand<T> softmaxCrossEntropyWithLogits(Operand<U> labels, Operand<T> logits, int axis) {
        return SoftmaxCrossEntropyWithLogits.softmaxCrossEntropyWithLogits(this.scope, labels, logits, axis);
    }

    public <T extends TNumber> Softsign<T> softsign(Operand<T> features) {
        return Softsign.create(this.scope, features);
    }

    public <T extends TType, U extends TNumber> SpaceToBatch<T> spaceToBatch(Operand<T> input, Operand<U> paddings, Long blockSize) {
        return SpaceToBatch.create(this.scope, input, paddings, blockSize);
    }

    public <T extends TType> SpaceToDepth<T> spaceToDepth(Operand<T> input, Long blockSize, SpaceToDepth.Options ... options) {
        return SpaceToDepth.create(this.scope, input, blockSize, options);
    }

    public <T extends TNumber, U extends TNumber> Operand sparseSoftmaxCrossEntropyWithLogits(Operand<T> labels, Operand<U> logits) {
        return SparseSoftmaxCrossEntropyWithLogits.sparseSoftmaxCrossEntropyWithLogits(this.scope, labels, logits);
    }

    public <T extends TNumber> TopK<T> topK(Operand<T> input, Operand<TInt32> k, TopK.Options ... options) {
        return TopK.create(this.scope, input, k, options);
    }
}

