/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.DataType;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.IntNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.types.TInt32Impl;
import org.tensorflow.types.family.TNumber;

public interface TInt32
extends IntNdArray,
TNumber {
    public static final DataType<TInt32> DTYPE = DataType.create("INT32", 3, 4, TInt32Impl::mapTensor);

    public static Tensor<TInt32> scalarOf(int value) {
        return Tensor.of(DTYPE, Shape.scalar(), data -> data.setInt(value, new long[0]));
    }

    public static Tensor<TInt32> vectorOf(int ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(DTYPE, Shape.of(values.length), data -> StdArrays.copyTo(values, (IntNdArray)data));
    }

    public static Tensor<TInt32> tensorOf(NdArray<Integer> src) {
        return Tensor.of(DTYPE, src.shape(), src::copyTo);
    }

    public static Tensor<TInt32> tensorOf(Shape shape) {
        return Tensor.of(DTYPE, shape);
    }

    public static Tensor<TInt32> tensorOf(Shape shape, IntDataBuffer data) {
        return Tensor.of(DTYPE, shape, d -> d.write(data));
    }

    public static Tensor<TInt32> tensorOf(Shape shape, Consumer<TInt32> dataInit) {
        return Tensor.of(DTYPE, shape, dataInit);
    }
}

