/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ReadOnlyBufferException;
import org.tensorflow.tools.buffer.DataBuffer;

public class Validator {
    public static void createArgs(long size, long maxSize) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        if (size > maxSize) {
            throw new IllegalArgumentException("Buffer size must be no greater than maximum size allowed (" + maxSize + ")");
        }
    }

    public static <T> void getArgs(DataBuffer<T> buffer, long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index must be non-negative");
        }
        if (index >= buffer.size()) {
            throw new IndexOutOfBoundsException("Index must be smaller than the buffer size");
        }
    }

    public static <T> void setArgs(DataBuffer<T> buffer, long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index must be non-negative");
        }
        if (index >= buffer.size()) {
            throw new IndexOutOfBoundsException("Index must be smaller than the buffer size");
        }
        if (buffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
    }

    public static <T> void copyToArgs(DataBuffer<T> src, DataBuffer<T> dst, long size) {
        if (dst == src) {
            throw new IllegalArgumentException("Source cannot be the same buffer as destination");
        }
        if (size > dst.size()) {
            throw new BufferOverflowException();
        }
        if (size > src.size()) {
            throw new BufferUnderflowException();
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
    }

    public static <T> void readArgs(DataBuffer<T> buffer, int arrayLength, int offset, int length) {
        if ((long)length > buffer.size()) {
            throw new BufferUnderflowException();
        }
        Validator.arrayArgs(arrayLength, offset, length);
    }

    public static <T> void writeArgs(DataBuffer<T> buffer, int arrayLength, int offset, int length) {
        if ((long)length > buffer.size()) {
            throw new BufferOverflowException();
        }
        if (buffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        Validator.arrayArgs(arrayLength, offset, length);
    }

    public static <T> void offsetArgs(DataBuffer<T> buffer, long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("Index must be non-negative");
        }
        if (index > buffer.size()) {
            throw new IllegalArgumentException("Index must not exceed buffer size");
        }
    }

    public static <T> void narrowArgs(DataBuffer<T> buffer, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        if (size > buffer.size()) {
            throw new IllegalArgumentException("Cannot narrow a buffer of size " + buffer.size() + " to " + size);
        }
    }

    public static <T> void sliceArgs(DataBuffer<T> buffer, long index, long size) {
        if (index < 0L) {
            throw new IllegalArgumentException("Index must be non-negative");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        if (index + size > buffer.size()) {
            throw new IllegalArgumentException("Buffer view must not exceed original buffer limits");
        }
    }

    private static void arrayArgs(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset must be non-negative");
        }
        if (offset > arrayLength) {
            throw new IndexOutOfBoundsException("Offset must be no larger than array length");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length must be non-negative");
        }
        if (length > arrayLength - offset) {
            throw new IndexOutOfBoundsException("Length must be no larger than array length minus the offset");
        }
    }
}

