/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class SparseApplyMomentum<T extends TType>
extends RawOp
implements Operand<T> {
    private Output<T> out;

    public static <T extends TType, U extends TNumber> SparseApplyMomentum<T> create(Scope scope, Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseApplyMomentum", scope.makeOpName("SparseApplyMomentum"));
        opBuilder.addInput(var.asOutput());
        opBuilder.addInput(accum.asOutput());
        opBuilder.addInput(lr.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(momentum.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.useLocking != null) {
                    opBuilder.setAttr("use_locking", opts.useLocking);
                }
                if (opts.useNesterov == null) continue;
                opBuilder.setAttr("use_nesterov", opts.useNesterov);
            }
        }
        return new SparseApplyMomentum<T>(opBuilder.build());
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public static Options useNesterov(Boolean useNesterov) {
        return new Options().useNesterov(useNesterov);
    }

    public Output<T> out() {
        return this.out;
    }

    @Override
    public Output<T> asOutput() {
        return this.out;
    }

    private SparseApplyMomentum(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean useLocking;
        private Boolean useNesterov;

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }

        public Options useNesterov(Boolean useNesterov) {
            this.useNesterov = useNesterov;
            return this;
        }

        private Options() {
        }
    }
}

