/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

public final class QuantizedInstanceNorm<T extends TType>
extends RawOp {
    private Output<T> y;
    private Output<TFloat32> yMin;
    private Output<TFloat32> yMax;

    public static <T extends TType> QuantizedInstanceNorm<T> create(Scope scope, Operand<T> x, Operand<TFloat32> xMin, Operand<TFloat32> xMax, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedInstanceNorm", scope.makeOpName("QuantizedInstanceNorm"));
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(xMin.asOutput());
        opBuilder.addInput(xMax.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.outputRangeGiven != null) {
                    opBuilder.setAttr("output_range_given", opts.outputRangeGiven);
                }
                if (opts.givenYMin != null) {
                    opBuilder.setAttr("given_y_min", opts.givenYMin.floatValue());
                }
                if (opts.givenYMax != null) {
                    opBuilder.setAttr("given_y_max", opts.givenYMax.floatValue());
                }
                if (opts.varianceEpsilon != null) {
                    opBuilder.setAttr("variance_epsilon", opts.varianceEpsilon.floatValue());
                }
                if (opts.minSeparation == null) continue;
                opBuilder.setAttr("min_separation", opts.minSeparation.floatValue());
            }
        }
        return new QuantizedInstanceNorm<T>(opBuilder.build());
    }

    public static Options outputRangeGiven(Boolean outputRangeGiven) {
        return new Options().outputRangeGiven(outputRangeGiven);
    }

    public static Options givenYMin(Float givenYMin) {
        return new Options().givenYMin(givenYMin);
    }

    public static Options givenYMax(Float givenYMax) {
        return new Options().givenYMax(givenYMax);
    }

    public static Options varianceEpsilon(Float varianceEpsilon) {
        return new Options().varianceEpsilon(varianceEpsilon);
    }

    public static Options minSeparation(Float minSeparation) {
        return new Options().minSeparation(minSeparation);
    }

    public Output<T> y() {
        return this.y;
    }

    public Output<TFloat32> yMin() {
        return this.yMin;
    }

    public Output<TFloat32> yMax() {
        return this.yMax;
    }

    private QuantizedInstanceNorm(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.y = operation.output(outputIdx++);
        this.yMin = operation.output(outputIdx++);
        this.yMax = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean outputRangeGiven;
        private Float givenYMin;
        private Float givenYMax;
        private Float varianceEpsilon;
        private Float minSeparation;

        public Options outputRangeGiven(Boolean outputRangeGiven) {
            this.outputRangeGiven = outputRangeGiven;
            return this;
        }

        public Options givenYMin(Float givenYMin) {
            this.givenYMin = givenYMin;
            return this;
        }

        public Options givenYMax(Float givenYMax) {
            this.givenYMax = givenYMax;
            return this;
        }

        public Options varianceEpsilon(Float varianceEpsilon) {
            this.varianceEpsilon = varianceEpsilon;
            return this;
        }

        public Options minSeparation(Float minSeparation) {
            this.minSeparation = minSeparation;
            return this;
        }

        private Options() {
        }
    }
}

