/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class LoadAndRemapMatrix
extends RawOp
implements Operand<TFloat32> {
    private Output<TFloat32> outputMatrix;

    public static LoadAndRemapMatrix create(Scope scope, Operand<TString> ckptPath, Operand<TString> oldTensorName, Operand<TInt64> rowRemapping, Operand<TInt64> colRemapping, Operand<TFloat32> initializingValues, Long numRows, Long numCols, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("LoadAndRemapMatrix", scope.makeOpName("LoadAndRemapMatrix"));
        opBuilder.addInput(ckptPath.asOutput());
        opBuilder.addInput(oldTensorName.asOutput());
        opBuilder.addInput(rowRemapping.asOutput());
        opBuilder.addInput(colRemapping.asOutput());
        opBuilder.addInput(initializingValues.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_rows", numRows);
        opBuilder.setAttr("num_cols", numCols);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxRowsInMemory == null) continue;
                opBuilder.setAttr("max_rows_in_memory", opts.maxRowsInMemory);
            }
        }
        return new LoadAndRemapMatrix(opBuilder.build());
    }

    public static Options maxRowsInMemory(Long maxRowsInMemory) {
        return new Options().maxRowsInMemory(maxRowsInMemory);
    }

    public Output<TFloat32> outputMatrix() {
        return this.outputMatrix;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.outputMatrix;
    }

    private LoadAndRemapMatrix(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputMatrix = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxRowsInMemory;

        public Options maxRowsInMemory(Long maxRowsInMemory) {
            this.maxRowsInMemory = maxRowsInMemory;
            return this;
        }

        private Options() {
        }
    }
}

