/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class SnapshotDataset
extends RawOp
implements Operand<TType> {
    private Output<?> handle;

    public static SnapshotDataset create(Scope scope, Operand<?> inputDataset, Operand<TString> path, List<DataType<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SnapshotDataset", scope.makeOpName("SnapshotDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(path.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = outputTypes.get(i);
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.compression != null) {
                    opBuilder.setAttr("compression", opts.compression);
                }
                if (opts.readerPathPrefix != null) {
                    opBuilder.setAttr("reader_path_prefix", opts.readerPathPrefix);
                }
                if (opts.writerPathPrefix != null) {
                    opBuilder.setAttr("writer_path_prefix", opts.writerPathPrefix);
                }
                if (opts.shardSizeBytes != null) {
                    opBuilder.setAttr("shard_size_bytes", opts.shardSizeBytes);
                }
                if (opts.pendingSnapshotExpirySeconds != null) {
                    opBuilder.setAttr("pending_snapshot_expiry_seconds", opts.pendingSnapshotExpirySeconds);
                }
                if (opts.numReaderThreads != null) {
                    opBuilder.setAttr("num_reader_threads", opts.numReaderThreads);
                }
                if (opts.readerBufferSize != null) {
                    opBuilder.setAttr("reader_buffer_size", opts.readerBufferSize);
                }
                if (opts.numWriterThreads != null) {
                    opBuilder.setAttr("num_writer_threads", opts.numWriterThreads);
                }
                if (opts.writerBufferSize != null) {
                    opBuilder.setAttr("writer_buffer_size", opts.writerBufferSize);
                }
                if (opts.shuffleOnRead != null) {
                    opBuilder.setAttr("shuffle_on_read", opts.shuffleOnRead);
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.mode != null) {
                    opBuilder.setAttr("mode", opts.mode);
                }
                if (opts.snapshotName == null) continue;
                opBuilder.setAttr("snapshot_name", opts.snapshotName);
            }
        }
        return new SnapshotDataset(opBuilder.build());
    }

    public static Options compression(String compression) {
        return new Options().compression(compression);
    }

    public static Options readerPathPrefix(String readerPathPrefix) {
        return new Options().readerPathPrefix(readerPathPrefix);
    }

    public static Options writerPathPrefix(String writerPathPrefix) {
        return new Options().writerPathPrefix(writerPathPrefix);
    }

    public static Options shardSizeBytes(Long shardSizeBytes) {
        return new Options().shardSizeBytes(shardSizeBytes);
    }

    public static Options pendingSnapshotExpirySeconds(Long pendingSnapshotExpirySeconds) {
        return new Options().pendingSnapshotExpirySeconds(pendingSnapshotExpirySeconds);
    }

    public static Options numReaderThreads(Long numReaderThreads) {
        return new Options().numReaderThreads(numReaderThreads);
    }

    public static Options readerBufferSize(Long readerBufferSize) {
        return new Options().readerBufferSize(readerBufferSize);
    }

    public static Options numWriterThreads(Long numWriterThreads) {
        return new Options().numWriterThreads(numWriterThreads);
    }

    public static Options writerBufferSize(Long writerBufferSize) {
        return new Options().writerBufferSize(writerBufferSize);
    }

    public static Options shuffleOnRead(Boolean shuffleOnRead) {
        return new Options().shuffleOnRead(shuffleOnRead);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options mode(String mode) {
        return new Options().mode(mode);
    }

    public static Options snapshotName(String snapshotName) {
        return new Options().snapshotName(snapshotName);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private SnapshotDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private String compression;
        private String readerPathPrefix;
        private String writerPathPrefix;
        private Long shardSizeBytes;
        private Long pendingSnapshotExpirySeconds;
        private Long numReaderThreads;
        private Long readerBufferSize;
        private Long numWriterThreads;
        private Long writerBufferSize;
        private Boolean shuffleOnRead;
        private Long seed;
        private Long seed2;
        private String mode;
        private String snapshotName;

        public Options compression(String compression) {
            this.compression = compression;
            return this;
        }

        public Options readerPathPrefix(String readerPathPrefix) {
            this.readerPathPrefix = readerPathPrefix;
            return this;
        }

        public Options writerPathPrefix(String writerPathPrefix) {
            this.writerPathPrefix = writerPathPrefix;
            return this;
        }

        public Options shardSizeBytes(Long shardSizeBytes) {
            this.shardSizeBytes = shardSizeBytes;
            return this;
        }

        public Options pendingSnapshotExpirySeconds(Long pendingSnapshotExpirySeconds) {
            this.pendingSnapshotExpirySeconds = pendingSnapshotExpirySeconds;
            return this;
        }

        public Options numReaderThreads(Long numReaderThreads) {
            this.numReaderThreads = numReaderThreads;
            return this;
        }

        public Options readerBufferSize(Long readerBufferSize) {
            this.readerBufferSize = readerBufferSize;
            return this;
        }

        public Options numWriterThreads(Long numWriterThreads) {
            this.numWriterThreads = numWriterThreads;
            return this;
        }

        public Options writerBufferSize(Long writerBufferSize) {
            this.writerBufferSize = writerBufferSize;
            return this;
        }

        public Options shuffleOnRead(Boolean shuffleOnRead) {
            this.shuffleOnRead = shuffleOnRead;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Options snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        private Options() {
        }
    }
}

