/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class VarHandleOp
extends RawOp
implements Operand<TType> {
    private Output<?> resource;

    public static <T extends TType> VarHandleOp create(Scope scope, DataType<T> dtype, Shape shape, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("VarHandleOp", scope.makeOpName("VarHandleOp"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", dtype);
        opBuilder.setAttr("shape", shape);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.allowedDevices == null) continue;
                String[] allowedDevicesArray = new String[opts.allowedDevices.size()];
                for (int i = 0; i < allowedDevicesArray.length; ++i) {
                    allowedDevicesArray[i] = (String)opts.allowedDevices.get(i);
                }
                opBuilder.setAttr("allowed_devices", allowedDevicesArray);
            }
        }
        return new VarHandleOp(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options allowedDevices(List<String> allowedDevices) {
        return new Options().allowedDevices(allowedDevices);
    }

    public Output<?> resource() {
        return this.resource;
    }

    @Override
    public Output<TType> asOutput() {
        return this.resource;
    }

    private VarHandleOp(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resource = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private List<String> allowedDevices;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options allowedDevices(List<String> allowedDevices) {
            this.allowedDevices = allowedDevices;
            return this;
        }

        private Options() {
        }
    }
}

