/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.tensorflow.DataType;
import org.tensorflow.Tensor;
import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.NdArrays;
import org.tensorflow.types.TStringImpl;
import org.tensorflow.types.family.TType;

public interface TString
extends NdArray<String>,
TType {
    public static final DataType<TString> DTYPE = DataType.create("STRING", 7, -1, TStringImpl::mapTensor);

    public static Tensor<TString> scalarOf(String value) {
        return TString.tensorOf(NdArrays.scalarOfObject(value));
    }

    public static Tensor<TString> vectorOf(String ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return TString.tensorOf(NdArrays.vectorOfObjects(values));
    }

    public static Tensor<TString> tensorOf(NdArray<String> src) {
        return TString.tensorOf(StandardCharsets.UTF_8, src);
    }

    public static Tensor<TString> tensorOf(Charset charset, NdArray<String> src) {
        return TStringImpl.createTensor(src, s -> s.getBytes(charset));
    }

    public static Tensor<TString> tensorOf(Shape shape, DataBuffer<String> data) {
        return TString.tensorOf(NdArrays.wrap(shape, data));
    }

    public static Tensor<TString> tensorOf(Charset charset, Shape shape, DataBuffer<String> data) {
        return TString.tensorOf(charset, NdArrays.wrap(shape, data));
    }

    public static Tensor<TString> tensorOfBytes(NdArray<byte[]> src) {
        return TStringImpl.createTensor(src, Function.identity());
    }

    public static Tensor<TString> tensorOfBytes(Shape shape, DataBuffer<byte[]> data) {
        return TString.tensorOfBytes(NdArrays.wrap(shape, data));
    }

    public TString using(Charset var1);

    public NdArray<byte[]> asBytes();
}

