/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.sequence;

import java.util.NoSuchElementException;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.tools.ndarray.impl.sequence.IndexedPositionIterator;

class NdPositionIterator
implements IndexedPositionIterator {
    private final DimensionalSpace dimensions;
    private long[] coords;

    @Override
    public boolean hasNext() {
        return this.coords != null;
    }

    @Override
    public long nextLong() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        long position = this.dimensions.positionOf(this.coords);
        this.increment();
        return position;
    }

    @Override
    public void forEachIndexed(IndexedPositionIterator.CoordsLongConsumer consumer) {
        while (this.hasNext()) {
            consumer.consume(this.coords, this.dimensions.positionOf(this.coords));
            this.increment();
        }
    }

    private void increment() {
        if (!NdPositionIterator.increment(this.coords, this.dimensions)) {
            this.coords = null;
        }
    }

    static boolean increment(long[] coords, DimensionalSpace dimensions) {
        for (int i = coords.length - 1; i >= 0; --i) {
            coords[i] = (coords[i] + 1L) % dimensions.get(i).numElements();
            if (coords[i] <= 0L) continue;
            return true;
        }
        return false;
    }

    NdPositionIterator(DimensionalSpace dimensions, int dimensionIdx) {
        this.dimensions = dimensions;
        this.coords = new long[dimensionIdx + 1];
    }
}

