/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.dense;

import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.ByteDataBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.ndarray.ByteNdArray;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.impl.dense.AbstractDenseNdArray;
import org.tensorflow.tools.ndarray.impl.dense.DataTransfer;
import org.tensorflow.tools.ndarray.impl.dense.Validator;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;

public class ByteDenseNdArray
extends AbstractDenseNdArray<Byte, ByteNdArray>
implements ByteNdArray {
    private final ByteDataBuffer buffer;

    public static ByteNdArray create(ByteDataBuffer buffer, Shape shape) {
        Validator.denseShape(buffer, shape);
        return new ByteDenseNdArray(buffer, shape);
    }

    @Override
    public byte getByte(long ... indices) {
        return this.buffer.getByte(this.positionOf(indices, true));
    }

    @Override
    public ByteNdArray setByte(byte value, long ... indices) {
        this.buffer.setByte(value, this.positionOf(indices, true));
        return this;
    }

    @Override
    public ByteNdArray copyTo(NdArray<Byte> dst) {
        Validator.copyToNdArrayArgs(this, dst);
        if (dst instanceof ByteDenseNdArray) {
            ByteDenseNdArray byteDst = (ByteDenseNdArray)dst;
            DataTransfer.execute(this.buffer, this.dimensions(), byteDst.buffer, byteDst.dimensions(), DataTransfer::ofByte);
        } else {
            this.slowCopyTo(dst);
        }
        return this;
    }

    @Override
    public ByteNdArray read(ByteDataBuffer dst) {
        Validator.readToBufferArgs(this, dst);
        DataTransfer.execute(this.buffer, this.dimensions(), dst, DataTransfer::ofByte);
        return this;
    }

    @Override
    public ByteNdArray write(ByteDataBuffer src) {
        Validator.writeFromBufferArgs(this, src);
        DataTransfer.execute(src, this.buffer, this.dimensions(), DataTransfer::ofByte);
        return this;
    }

    protected ByteDenseNdArray(ByteDataBuffer buffer, Shape shape) {
        this(buffer, DimensionalSpace.create(shape));
    }

    @Override
    ByteDenseNdArray instantiate(DataBuffer<Byte> buffer, DimensionalSpace dimensions) {
        return new ByteDenseNdArray((ByteDataBuffer)buffer, dimensions);
    }

    protected ByteDataBuffer buffer() {
        return this.buffer;
    }

    private ByteDenseNdArray(ByteDataBuffer buffer, DimensionalSpace dimensions) {
        super(dimensions);
        this.buffer = buffer;
    }
}

