/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.raw;

import java.nio.IntBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DataStorageVisitor;
import org.tensorflow.tools.buffer.IntDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.raw.AbstractRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.UnsafeMemoryHandle;

final class IntRawDataBuffer
extends AbstractRawDataBuffer<Integer, IntDataBuffer>
implements IntDataBuffer {
    @Override
    public int getInt(long index) {
        Validator.getArgs(this, index);
        return this.memory.getInt(index);
    }

    @Override
    public IntDataBuffer setInt(int value, long index) {
        Validator.setArgs(this, index);
        this.memory.setInt(value, index);
        return this;
    }

    @Override
    public IntDataBuffer read(int[] dst) {
        return (IntDataBuffer)this.read(dst, dst.length);
    }

    @Override
    public IntDataBuffer read(int[] dst, int offset, int length) {
        return (IntDataBuffer)this.read(dst, dst.length, offset, length);
    }

    @Override
    public IntDataBuffer write(int[] src) {
        return (IntDataBuffer)this.write(src, src.length);
    }

    @Override
    public IntDataBuffer write(int[] src, int offset, int length) {
        return (IntDataBuffer)this.write(src, src.length, offset, length);
    }

    @Override
    public IntDataBuffer copyTo(final DataBuffer<Integer> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<IntDataBuffer>(){

            @Override
            public IntDataBuffer visit(IntBuffer buffer) {
                if (buffer.hasArray()) {
                    IntRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromArray(buffer.array(), buffer.position(), buffer.limit()), size);
                } else if (IntRawDataBuffer.this.memory.isArray()) {
                    buffer.put(IntRawDataBuffer.this.memory.toArrayIntBuffer());
                } else {
                    IntRawDataBuffer.this.slowCopyTo(dst, size);
                }
                return IntRawDataBuffer.this;
            }

            @Override
            public IntDataBuffer visit(long address, long length, long scale) {
                IntRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromAddress(address, length, scale), size);
                return IntRawDataBuffer.this;
            }

            @Override
            public IntDataBuffer fallback() {
                if (dst instanceof IntDataBuffer) {
                    IntDataBuffer intDst = (IntDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        intDst.setInt(IntRawDataBuffer.this.getInt(idx), idx);
                    }
                    return IntRawDataBuffer.this;
                }
                return (IntDataBuffer)IntRawDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        if (this.memory.isArray()) {
            return visitor.visit(this.memory.toArrayIntBuffer());
        }
        return visitor.visit(this.memory.byteOffset, this.memory.byteSize, this.memory.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntDataBuffer)) {
            return super.equals(obj);
        }
        final IntDataBuffer other = (IntDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(IntBuffer buffer) {
                if (IntRawDataBuffer.this.memory.isArray()) {
                    return buffer.equals(IntRawDataBuffer.this.memory.toArrayIntBuffer());
                }
                return this.fallback();
            }

            @Override
            public Boolean fallback() {
                for (long idx = 0L; idx < IntRawDataBuffer.this.size(); ++idx) {
                    if (other.getInt(idx) == IntRawDataBuffer.this.getInt(idx)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected IntDataBuffer instantiate(UnsafeMemoryHandle memory) {
        return new IntRawDataBuffer(memory, this.readOnly);
    }

    IntRawDataBuffer(UnsafeMemoryHandle memory, boolean readOnly) {
        super(memory, readOnly);
    }
}

