/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.misc;

import java.util.BitSet;
import org.tensorflow.tools.buffer.BooleanDataBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DataStorageVisitor;
import org.tensorflow.tools.buffer.impl.AbstractDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;

class BitSetDataBuffer
extends AbstractDataBuffer<Boolean>
implements BooleanDataBuffer {
    private final BitSet bitSet;
    private final long numBits;
    private final boolean readOnly;
    private final int offset;

    @Override
    public long size() {
        return this.numBits;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean getBoolean(long index) {
        Validator.getArgs(this, index);
        return this.bitSet.get((int)index + this.offset);
    }

    @Override
    public BooleanDataBuffer setBoolean(boolean value, long index) {
        Validator.setArgs(this, index);
        this.bitSet.set((int)index + this.offset, value);
        return this;
    }

    @Override
    public BooleanDataBuffer read(boolean[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        int i = this.offset;
        int j = offset;
        while (i < this.offset + length) {
            dst[j] = this.bitSet.get(i);
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public BooleanDataBuffer write(boolean[] src, int offset, int length) {
        Validator.readArgs(this, src.length, offset, length);
        int i = this.offset;
        int j = offset;
        while (i < this.offset + length) {
            this.bitSet.set(i, src[j]);
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public BooleanDataBuffer copyTo(final DataBuffer<Boolean> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<BooleanDataBuffer>(){

            @Override
            public BooleanDataBuffer visit(boolean[] array, int arrayOffset, int arrayLength) {
                int idx = 0;
                while ((long)idx < size) {
                    array[idx + arrayOffset] = BitSetDataBuffer.this.bitSet.get(idx + BitSetDataBuffer.this.offset);
                    ++idx;
                }
                return BitSetDataBuffer.this;
            }

            @Override
            public BooleanDataBuffer visit(BitSet dstBitSet, int dstOffset, long numBits) {
                int idx = 0;
                while ((long)idx < size) {
                    dstBitSet.set(idx + dstOffset, BitSetDataBuffer.this.bitSet.get(idx + BitSetDataBuffer.this.offset));
                    ++idx;
                }
                return BitSetDataBuffer.this;
            }

            @Override
            public BooleanDataBuffer fallback() {
                if (dst instanceof BooleanDataBuffer) {
                    BooleanDataBuffer booleanDst = (BooleanDataBuffer)dst;
                    int idx = 0;
                    while ((long)idx < size) {
                        booleanDst.setBoolean(BitSetDataBuffer.this.bitSet.get(idx + BitSetDataBuffer.this.offset), idx);
                        ++idx;
                    }
                } else {
                    int idx = 0;
                    while ((long)idx < size) {
                        dst.setObject(BitSetDataBuffer.this.bitSet.get(idx + BitSetDataBuffer.this.offset), idx);
                        ++idx;
                    }
                }
                return BitSetDataBuffer.this;
            }
        });
    }

    @Override
    public BooleanDataBuffer slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        return new BitSetDataBuffer(this.bitSet, size, this.readOnly, this.offset + (int)index);
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.bitSet, this.offset, this.numBits);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BooleanDataBuffer)) {
            return super.equals(obj);
        }
        final BooleanDataBuffer other = (BooleanDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(boolean[] array, int arrayOffset, int length) {
                int idx = 0;
                while ((long)idx < BitSetDataBuffer.this.size()) {
                    if (array[idx + arrayOffset] != BitSetDataBuffer.this.bitSet.get(idx + BitSetDataBuffer.this.offset)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }

            @Override
            public Boolean visit(BitSet otherBitSet, int otherOffset, long otherNumBits) {
                if (BitSetDataBuffer.this.offset == 0 && otherOffset == 0 && BitSetDataBuffer.this.numBits == otherNumBits) {
                    return BitSetDataBuffer.this.bitSet.equals(otherBitSet);
                }
                int idx = 0;
                while ((long)idx < BitSetDataBuffer.this.size()) {
                    if (otherBitSet.get(idx + otherOffset) != BitSetDataBuffer.this.bitSet.get(idx + BitSetDataBuffer.this.offset)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }

            @Override
            public Boolean fallback() {
                int idx = 0;
                while ((long)idx < BitSetDataBuffer.this.size()) {
                    if (other.getBoolean(idx) != BitSetDataBuffer.this.bitSet.get(idx + BitSetDataBuffer.this.offset)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        });
    }

    BitSetDataBuffer(BitSet bitSet, long numBits, boolean readOnly) {
        this(bitSet, numBits, readOnly, 0);
    }

    private BitSetDataBuffer(BitSet bitSet, long numBits, boolean readOnly, int offset) {
        this.bitSet = bitSet;
        this.numBits = numBits;
        this.readOnly = readOnly;
        this.offset = offset;
    }
}

