/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.layout;

import org.tensorflow.tools.buffer.ByteDataBuffer;
import org.tensorflow.tools.buffer.layout.BooleanDataLayout;

public final class BoolLayout
implements BooleanDataLayout<ByteDataBuffer> {
    @Override
    public void writeBoolean(ByteDataBuffer buffer, boolean value, long index) {
        buffer.setByte(BoolLayout.booleanToByte(value), index);
    }

    @Override
    public boolean readBoolean(ByteDataBuffer buffer, long index) {
        return BoolLayout.byteToBoolean(buffer.getByte(index));
    }

    static byte booleanToByte(boolean b) {
        return (byte)(b ? 1 : 0);
    }

    static boolean byteToBoolean(byte b) {
        return b != 0;
    }
}

