/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

public final class RandomPoisson<V extends TNumber>
extends RawOp
implements Operand<V> {
    private Output<V> output;

    public static <V extends TNumber, T extends TNumber, U extends TNumber> RandomPoisson<V> create(Scope scope, Operand<T> shape, Operand<U> rate, DataType<V> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("RandomPoissonV2", scope.makeOpName("RandomPoisson"));
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(rate.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", dtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new RandomPoisson<V>(opBuilder.build());
    }

    public static <T extends TNumber, U extends TNumber> RandomPoisson<TInt64> create(Scope scope, Operand<T> shape, Operand<U> rate, Options ... options) {
        return RandomPoisson.create(scope, shape, rate, TInt64.DTYPE, options);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    private RandomPoisson(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

