/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class SparseMatrixTranspose
extends RawOp
implements Operand<TType> {
    private Output<?> output;

    public static <T extends TType> SparseMatrixTranspose create(Scope scope, Operand<?> input, DataType<T> type, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseMatrixTranspose", scope.makeOpName("SparseMatrixTranspose"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("type", type);
        if (options != null) {
            for (Options opts : options) {
                if (opts.conjugate == null) continue;
                opBuilder.setAttr("conjugate", opts.conjugate);
            }
        }
        return new SparseMatrixTranspose(opBuilder.build());
    }

    public static Options conjugate(Boolean conjugate) {
        return new Options().conjugate(conjugate);
    }

    public Output<?> output() {
        return this.output;
    }

    @Override
    public Output<TType> asOutput() {
        return this.output;
    }

    private SparseMatrixTranspose(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean conjugate;

        public Options conjugate(Boolean conjugate) {
            this.conjugate = conjugate;
            return this;
        }

        private Options() {
        }
    }
}

