/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.tools.Shape;
import org.tensorflow.types.family.TType;

public final class TemporaryVariable<T extends TType>
extends RawOp
implements Operand<T> {
    private Output<T> ref;

    public static <T extends TType> TemporaryVariable<T> create(Scope scope, Shape shape, DataType<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("TemporaryVariable", scope.makeOpName("TemporaryVariable"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("shape", shape);
        opBuilder.setAttr("dtype", dtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.varName == null) continue;
                opBuilder.setAttr("var_name", opts.varName);
            }
        }
        return new TemporaryVariable<T>(opBuilder.build());
    }

    public static Options varName(String varName) {
        return new Options().varName(varName);
    }

    public Output<T> ref() {
        return this.ref;
    }

    @Override
    public Output<T> asOutput() {
        return this.ref;
    }

    private TemporaryVariable(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.ref = operation.output(outputIdx++);
    }

    public static class Options {
        private String varName;

        public Options varName(String varName) {
            this.varName = varName;
            return this;
        }

        private Options() {
        }
    }
}

