/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.tools.Shape;
import org.tensorflow.types.family.TType;

public final class Placeholder<T extends TType>
extends RawOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends TType> Placeholder<T> create(Scope scope, DataType<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("Placeholder", scope.makeOpName("Placeholder"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", dtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.shape == null) continue;
                opBuilder.setAttr("shape", opts.shape);
            }
        }
        return new Placeholder<T>(opBuilder.build());
    }

    public static Options shape(Shape shape) {
        return new Options().shape(shape);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Placeholder(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Shape shape;

        public Options shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        private Options() {
        }
    }
}

