/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.audio;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

public final class Mfcc
extends RawOp
implements Operand<TFloat32> {
    private Output<TFloat32> output;

    public static Mfcc create(Scope scope, Operand<TFloat32> spectrogram, Operand<TInt32> sampleRate, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("Mfcc", scope.makeOpName("Mfcc"));
        opBuilder.addInput(spectrogram.asOutput());
        opBuilder.addInput(sampleRate.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.upperFrequencyLimit != null) {
                    opBuilder.setAttr("upper_frequency_limit", opts.upperFrequencyLimit.floatValue());
                }
                if (opts.lowerFrequencyLimit != null) {
                    opBuilder.setAttr("lower_frequency_limit", opts.lowerFrequencyLimit.floatValue());
                }
                if (opts.filterbankChannelCount != null) {
                    opBuilder.setAttr("filterbank_channel_count", opts.filterbankChannelCount);
                }
                if (opts.dctCoefficientCount == null) continue;
                opBuilder.setAttr("dct_coefficient_count", opts.dctCoefficientCount);
            }
        }
        return new Mfcc(opBuilder.build());
    }

    public static Options upperFrequencyLimit(Float upperFrequencyLimit) {
        return new Options().upperFrequencyLimit(upperFrequencyLimit);
    }

    public static Options lowerFrequencyLimit(Float lowerFrequencyLimit) {
        return new Options().lowerFrequencyLimit(lowerFrequencyLimit);
    }

    public static Options filterbankChannelCount(Long filterbankChannelCount) {
        return new Options().filterbankChannelCount(filterbankChannelCount);
    }

    public static Options dctCoefficientCount(Long dctCoefficientCount) {
        return new Options().dctCoefficientCount(dctCoefficientCount);
    }

    public Output<TFloat32> output() {
        return this.output;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.output;
    }

    private Mfcc(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Float upperFrequencyLimit;
        private Float lowerFrequencyLimit;
        private Long filterbankChannelCount;
        private Long dctCoefficientCount;

        public Options upperFrequencyLimit(Float upperFrequencyLimit) {
            this.upperFrequencyLimit = upperFrequencyLimit;
            return this;
        }

        public Options lowerFrequencyLimit(Float lowerFrequencyLimit) {
            this.lowerFrequencyLimit = lowerFrequencyLimit;
            return this;
        }

        public Options filterbankChannelCount(Long filterbankChannelCount) {
            this.filterbankChannelCount = filterbankChannelCount;
            return this;
        }

        public Options dctCoefficientCount(Long dctCoefficientCount) {
            this.dctCoefficientCount = dctCoefficientCount;
            return this;
        }

        private Options() {
        }
    }
}

