/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.audio;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;

public final class AudioSpectrogram
extends RawOp
implements Operand<TFloat32> {
    private Output<TFloat32> spectrogram;

    public static AudioSpectrogram create(Scope scope, Operand<TFloat32> input, Long windowSize, Long stride, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("AudioSpectrogram", scope.makeOpName("AudioSpectrogram"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("window_size", windowSize);
        opBuilder.setAttr("stride", stride);
        if (options != null) {
            for (Options opts : options) {
                if (opts.magnitudeSquared == null) continue;
                opBuilder.setAttr("magnitude_squared", opts.magnitudeSquared);
            }
        }
        return new AudioSpectrogram(opBuilder.build());
    }

    public static Options magnitudeSquared(Boolean magnitudeSquared) {
        return new Options().magnitudeSquared(magnitudeSquared);
    }

    public Output<TFloat32> spectrogram() {
        return this.spectrogram;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.spectrogram;
    }

    private AudioSpectrogram(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.spectrogram = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean magnitudeSquared;

        public Options magnitudeSquared(Boolean magnitudeSquared) {
            this.magnitudeSquared = magnitudeSquared;
            return this;
        }

        private Options() {
        }
    }
}

