/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.Graph;
import org.tensorflow.Session;
import org.tensorflow.TensorFlow;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Session;
import org.tensorflow.internal.c_api.TF_SessionOptions;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.proto.framework.ConfigProto;
import org.tensorflow.proto.framework.MetaGraphDef;
import org.tensorflow.proto.framework.RunOptions;

public class SavedModelBundle
implements AutoCloseable {
    private final Graph graph;
    private final Session session;
    private final MetaGraphDef metaGraphDef;

    public static SavedModelBundle load(String exportDir, String ... tags) {
        return SavedModelBundle.loader(exportDir).withTags(tags).load();
    }

    public static Loader loader(String exportDir) {
        return new Loader(exportDir);
    }

    public MetaGraphDef metaGraphDef() {
        return this.metaGraphDef;
    }

    public Graph graph() {
        return this.graph;
    }

    public Session session() {
        return this.session;
    }

    @Override
    public void close() {
        this.session.close();
        this.graph.close();
    }

    private SavedModelBundle(Graph graph, Session session, MetaGraphDef metaGraphDef) {
        this.graph = graph;
        this.session = session;
        this.metaGraphDef = metaGraphDef;
    }

    private static SavedModelBundle fromHandle(TF_Graph graphHandle, TF_Session sessionHandle, MetaGraphDef metaGraphDef) {
        Graph graph = new Graph(graphHandle);
        Session session = new Session(graph, sessionHandle);
        return new SavedModelBundle(graph, session, metaGraphDef);
    }

    private static SavedModelBundle load(String exportDir, String[] tags, ConfigProto config, RunOptions runOptions) {
        SavedModelBundle bundle = null;
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            TF_SessionOptions opts = TF_SessionOptions.newSessionOptions();
            if (config != null) {
                BytePointer configBytes = new BytePointer(config.toByteArray());
                tensorflow.TF_SetConfig(opts, (Pointer)configBytes, configBytes.capacity(), status);
                status.throwExceptionIfNotOK();
            }
            TF_Buffer runOpts = TF_Buffer.newBufferFromString((Message)runOptions);
            TF_Graph graph = tensorflow.TF_NewGraph();
            TF_Buffer metagraphDef = TF_Buffer.newBuffer();
            TF_Session session = tensorflow.TF_LoadSessionFromSavedModel(opts, runOpts, new BytePointer(exportDir), new PointerPointer(tags), tags.length, graph, metagraphDef, status);
            status.throwExceptionIfNotOK();
            try {
                bundle = SavedModelBundle.fromHandle(graph, session, MetaGraphDef.parseFrom(metagraphDef.dataAsByteBuffer()));
            }
            catch (InvalidProtocolBufferException e) {
                throw new TensorFlowException("Cannot parse MetaGraphDef protocol buffer", e);
            }
        }
        return bundle;
    }

    static {
        TensorFlow.init();
    }

    public static final class Loader {
        private String exportDir = null;
        private String[] tags = null;
        private ConfigProto configProto = null;
        private RunOptions runOptions = null;

        public SavedModelBundle load() {
            return SavedModelBundle.load(this.exportDir, this.tags, this.configProto, this.runOptions);
        }

        public Loader withRunOptions(RunOptions options) {
            this.runOptions = options;
            return this;
        }

        public Loader withConfigProto(ConfigProto configProto) {
            this.configProto = configProto;
            return this;
        }

        public Loader withTags(String ... tags) {
            this.tags = tags;
            return this;
        }

        private Loader(String exportDir) {
            this.exportDir = exportDir;
        }
    }
}

