/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;

public final class Dilation2dBackpropInput<T extends TNumber>
extends RawOp
implements Operand<T> {
    private Output<T> inBackprop;

    public static <T extends TNumber> Dilation2dBackpropInput<T> create(Scope scope, Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        OperationBuilder opBuilder = scope.env().opBuilder("Dilation2DBackpropInput", scope.makeOpName("Dilation2dBackpropInput"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(outBackprop.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        long[] ratesArray = new long[rates.size()];
        for (int i = 0; i < ratesArray.length; ++i) {
            ratesArray[i] = rates.get(i);
        }
        opBuilder.setAttr("rates", ratesArray);
        opBuilder.setAttr("padding", padding);
        return new Dilation2dBackpropInput<T>(opBuilder.build());
    }

    public Output<T> inBackprop() {
        return this.inBackprop;
    }

    @Override
    public Output<T> asOutput() {
        return this.inBackprop;
    }

    private Dilation2dBackpropInput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.inBackprop = operation.output(outputIdx++);
    }
}

