/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DynamicStitch", inputsClass=Inputs.class)
public final class DynamicStitch<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DynamicStitch";
    private Output<T> merged;

    public DynamicStitch(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.merged = operation.output(outputIdx++);
    }

    public static <T extends TType> DynamicStitch<T> create(Scope scope, Iterable<Operand<TInt32>> indices, Iterable<Operand<T>> data) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(indices));
        opBuilder.addInputList(Operands.asOutputs(data));
        return new DynamicStitch<T>(opBuilder.build());
    }

    public Output<T> merged() {
        return this.merged;
    }

    @Override
    public Output<T> asOutput() {
        return this.merged;
    }

    @OpInputsMetadata(outputsClass=DynamicStitch.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<DynamicStitch<T>> {
        public final Iterable<Operand<TInt32>> indices;
        public final Iterable<Operand<T>> data;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new DynamicStitch(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            int indicesLength = op.inputListLength("indices");
            this.indices = Arrays.asList((Operand[])op.inputList(inputIndex, indicesLength));
            int dataLength = op.inputListLength("data");
            this.data = Arrays.asList((Operand[])op.inputList(inputIndex += indicesLength, dataLength));
            inputIndex += dataLength;
            this.T = op.attributes().getAttrType("T");
        }
    }
}

