/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse;

import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.ByteNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.ByteSparseSlice;
import org.tensorflow.ndarray.index.Index;

public class ByteSparseNdArray
extends AbstractSparseNdArray<Byte, ByteNdArray>
implements ByteNdArray {
    protected ByteSparseNdArray(LongNdArray indices, ByteNdArray values, byte defaultValue, DimensionalSpace dimensions) {
        super(indices, values, defaultValue, dimensions);
    }

    ByteSparseNdArray(LongNdArray indices, ByteNdArray values, DimensionalSpace dimensions) {
        this(indices, values, 0, dimensions);
    }

    ByteSparseNdArray(ByteDataBuffer dataBuffer, DimensionalSpace dimensions) {
        this(dataBuffer, 0, dimensions);
    }

    ByteSparseNdArray(ByteDataBuffer dataBuffer, byte defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
        this.copyFrom(dataBuffer);
    }

    ByteSparseNdArray(DimensionalSpace dimensions) {
        this(0, dimensions);
    }

    ByteSparseNdArray(byte defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
    }

    public static ByteSparseNdArray create(LongNdArray indices, ByteNdArray values, DimensionalSpace dimensions) {
        return new ByteSparseNdArray(indices, values, dimensions);
    }

    public static ByteSparseNdArray create(LongNdArray indices, ByteNdArray values, byte defaultValue, DimensionalSpace dimensions) {
        return new ByteSparseNdArray(indices, values, defaultValue, dimensions);
    }

    public static ByteSparseNdArray create(ByteDataBuffer dataBuffer, DimensionalSpace dimensions) {
        return new ByteSparseNdArray(dataBuffer, dimensions);
    }

    public static ByteSparseNdArray create(ByteDataBuffer dataBuffer, byte defaultValue, DimensionalSpace dimensions) {
        return new ByteSparseNdArray(dataBuffer, defaultValue, dimensions);
    }

    public static ByteSparseNdArray create(DimensionalSpace dimensions) {
        return new ByteSparseNdArray(dimensions);
    }

    public static ByteSparseNdArray create(byte defaultValue, DimensionalSpace dimensions) {
        return new ByteSparseNdArray(defaultValue, dimensions);
    }

    public static ByteSparseNdArray create(ByteDataBuffer buffer, Shape shape) {
        return new ByteSparseNdArray(buffer, DimensionalSpace.create(shape));
    }

    public static ByteSparseNdArray create(ByteDataBuffer buffer, byte defaultValue, Shape shape) {
        return new ByteSparseNdArray(buffer, defaultValue, DimensionalSpace.create(shape));
    }

    public static ByteSparseNdArray create(ByteNdArray src) {
        ByteDataBuffer buffer = DataBuffers.ofBytes(src.size());
        src.copyTo(buffer);
        return new ByteSparseNdArray(buffer, DimensionalSpace.create(src.shape()));
    }

    public static ByteSparseNdArray create(ByteNdArray src, byte defaultValue) {
        ByteDataBuffer buffer = DataBuffers.ofBytes(src.size());
        src.copyTo(buffer);
        return new ByteSparseNdArray(buffer, defaultValue, DimensionalSpace.create(src.shape()));
    }

    @Override
    public ByteNdArray createValues(Shape shape) {
        return NdArrays.ofBytes(shape);
    }

    @Override
    public ByteNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new ByteSparseSlice(this, position, sliceDimensions);
    }

    @Override
    public byte getByte(long ... coordinates) {
        return (Byte)this.getObject(coordinates);
    }

    @Override
    public ByteNdArray setByte(byte value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteNdArray copyTo(DataBuffer<Byte> dst) {
        return this.copyTo((ByteDataBuffer)dst);
    }

    @Override
    public ByteNdArray copyTo(ByteDataBuffer dst) {
        Object[] defaults = new Byte[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            byte value = ((ByteNdArray)this.getValues()).getByte(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public ByteNdArray copyFrom(ByteDataBuffer src) {
        ArrayList<long[]> indices = new ArrayList<long[]>();
        ArrayList<Byte> values = new ArrayList<Byte>();
        for (long i = 0L; i < src.size(); ++i) {
            if (src.getObject(i).equals(this.getDefaultValue())) continue;
            indices.add(this.toCoordinates(this.dimensions, i));
            values.add(src.getObject(i));
        }
        long[][] indicesArray = new long[indices.size()][];
        byte[] valuesArray = new byte[values.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indicesArray[i] = (long[])indices.get(i);
            valuesArray[i] = (Byte)values.get(i);
        }
        this.setIndices(StdArrays.ndCopyOf(indicesArray));
        this.setValues(NdArrays.vectorOf(valuesArray));
        return this;
    }

    @Override
    public ByteNdArray copyFrom(DataBuffer<Byte> src) {
        return this.copyFrom((ByteDataBuffer)src);
    }

    @Override
    public ByteNdArray toDense() {
        ByteDataBuffer dataBuffer = DataBuffers.ofBytes(this.shape().size());
        this.copyTo(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    public ByteNdArray fromDense(ByteNdArray src) {
        ByteDataBuffer buffer = DataBuffers.ofBytes(src.size());
        src.copyTo(buffer);
        this.copyFrom(buffer);
        return this;
    }

    @Override
    public ByteNdArray slice(Index ... indices) {
        return (ByteNdArray)super.slice(indices);
    }

    @Override
    public ByteNdArray get(long ... coordinates) {
        return (ByteNdArray)super.get(coordinates);
    }

    @Override
    public ByteNdArray setObject(Byte value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteNdArray set(NdArray<Byte> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteNdArray copyTo(NdArray<Byte> dst) {
        return (ByteNdArray)super.copyTo(dst);
    }

    @Override
    public ByteNdArray createDefaultArray() {
        return NdArrays.scalarOf((Byte)this.getDefaultValue());
    }
}

