/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

@OpMetadata(opType="SparseCrossV2", inputsClass=Inputs.class)
public final class SparseCross
extends RawOp {
    public static final String OP_NAME = "SparseCrossV2";
    private Output<TInt64> outputIndices;
    private Output<TString> outputValues;
    private Output<TInt64> outputShape;

    public SparseCross(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }

    public static SparseCross create(Scope scope, Iterable<Operand<TInt64>> indices, Iterable<Operand<?>> values, Iterable<Operand<TInt64>> shapes, Iterable<Operand<?>> denseInputs, Operand<TString> sep) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SparseCross");
        opBuilder.addInputList(Operands.asOutputs(indices));
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(shapes));
        opBuilder.addInputList(Operands.asOutputs(denseInputs));
        opBuilder.addInput(sep.asOutput());
        return new SparseCross(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<TString> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputShape() {
        return this.outputShape;
    }

    @OpInputsMetadata(outputsClass=SparseCross.class)
    public static class Inputs
    extends RawOpInputs<SparseCross> {
        public final Iterable<Operand<TInt64>> indices;
        public final Iterable<Operand<?>> values;
        public final Iterable<Operand<TInt64>> shapes;
        public final Iterable<Operand<?>> denseInputs;
        public final Operand<TString> sep;
        public final DataType[] sparseTypes;
        public final DataType[] denseTypes;

        public Inputs(GraphOperation op) {
            super(new SparseCross(op), op, Arrays.asList("sparse_types", "dense_types"));
            int inputIndex = 0;
            int indicesLength = op.inputListLength("indices");
            this.indices = Arrays.asList((Operand[])op.inputList(inputIndex, indicesLength));
            int valuesLength = op.inputListLength("values");
            this.values = Arrays.asList((Operand[])op.inputList(inputIndex += indicesLength, valuesLength));
            int shapesLength = op.inputListLength("shapes");
            this.shapes = Arrays.asList((Operand[])op.inputList(inputIndex += valuesLength, shapesLength));
            int denseInputsLength = op.inputListLength("dense_inputs");
            this.denseInputs = Arrays.asList((Operand[])op.inputList(inputIndex += shapesLength, denseInputsLength));
            inputIndex += denseInputsLength;
            this.sep = op.input(inputIndex++);
            this.sparseTypes = op.attributes().getAttrTypeList("sparse_types");
            this.denseTypes = op.attributes().getAttrTypeList("dense_types");
        }
    }
}

