/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UnicodeDecode", inputsClass=Inputs.class)
public final class UnicodeDecode<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "UnicodeDecode";
    private Output<T> rowSplits;
    private Output<TInt32> charValues;

    public UnicodeDecode(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.rowSplits = operation.output(outputIdx++);
        this.charValues = operation.output(outputIdx++);
    }

    public static <T extends TNumber> UnicodeDecode<T> create(Scope scope, Operand<TString> input, String inputEncoding, Class<T> Tsplits, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("input_encoding", inputEncoding);
        opBuilder.setAttr("Tsplits", Operands.toDataType(Tsplits));
        if (options != null) {
            for (Options opts : options) {
                if (opts.errors != null) {
                    opBuilder.setAttr("errors", opts.errors);
                }
                if (opts.replacementChar != null) {
                    opBuilder.setAttr("replacement_char", opts.replacementChar);
                }
                if (opts.replaceControlCharacters == null) continue;
                opBuilder.setAttr("replace_control_characters", opts.replaceControlCharacters);
            }
        }
        return new UnicodeDecode<T>(opBuilder.build());
    }

    public static UnicodeDecode<TInt64> create(Scope scope, Operand<TString> input, String inputEncoding, Options[] options) {
        return UnicodeDecode.create(scope, input, inputEncoding, TInt64.class, options);
    }

    public static Options errors(String errors) {
        return new Options().errors(errors);
    }

    public static Options replacementChar(Long replacementChar) {
        return new Options().replacementChar(replacementChar);
    }

    public static Options replaceControlCharacters(Boolean replaceControlCharacters) {
        return new Options().replaceControlCharacters(replaceControlCharacters);
    }

    public Output<T> rowSplits() {
        return this.rowSplits;
    }

    public Output<TInt32> charValues() {
        return this.charValues;
    }

    @OpInputsMetadata(outputsClass=UnicodeDecode.class)
    public static class Inputs
    extends RawOpInputs<UnicodeDecode<?>> {
        public final Operand<TString> input;
        public final String inputEncoding;
        public final String errors;
        public final long replacementChar;
        public final boolean replaceControlCharacters;
        public final DataType Tsplits;

        public Inputs(GraphOperation op) {
            super(new UnicodeDecode(op), op, Arrays.asList("input_encoding", "errors", "replacement_char", "replace_control_characters", "Tsplits"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.inputEncoding = op.attributes().getAttrString("input_encoding");
            this.errors = op.attributes().getAttrString("errors");
            this.replacementChar = op.attributes().getAttrInt("replacement_char");
            this.replaceControlCharacters = op.attributes().getAttrBool("replace_control_characters");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
        }
    }

    public static class Options {
        private String errors;
        private Long replacementChar;
        private Boolean replaceControlCharacters;

        private Options() {
        }

        public Options errors(String errors) {
            this.errors = errors;
            return this;
        }

        public Options replacementChar(Long replacementChar) {
            this.replacementChar = replacementChar;
            return this;
        }

        public Options replaceControlCharacters(Boolean replaceControlCharacters) {
            this.replaceControlCharacters = replaceControlCharacters;
            return this;
        }
    }
}

