/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizedMatMulWithBiasAndReluAndRequantize", inputsClass=Inputs.class)
public final class QuantizedMatMulWithBiasAndReluAndRequantize<W extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizedMatMulWithBiasAndReluAndRequantize";
    private Output<W> out;
    private Output<TFloat32> minOut;
    private Output<TFloat32> maxOut;

    public QuantizedMatMulWithBiasAndReluAndRequantize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
        this.minOut = operation.output(outputIdx++);
        this.maxOut = operation.output(outputIdx++);
    }

    public static <W extends TNumber> QuantizedMatMulWithBiasAndReluAndRequantize<W> create(Scope scope, Operand<? extends TNumber> a, Operand<? extends TNumber> b, Operand<? extends TNumber> bias, Operand<TFloat32> minA, Operand<TFloat32> maxA, Operand<TFloat32> minB, Operand<TFloat32> maxB, Operand<TFloat32> minFreezedOutput, Operand<TFloat32> maxFreezedOutput, Class<W> Toutput, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minA.asOutput());
        opBuilder.addInput(maxA.asOutput());
        opBuilder.addInput(minB.asOutput());
        opBuilder.addInput(maxB.asOutput());
        opBuilder.addInput(minFreezedOutput.asOutput());
        opBuilder.addInput(maxFreezedOutput.asOutput());
        opBuilder.setAttr("Toutput", Operands.toDataType(Toutput));
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB != null) {
                    opBuilder.setAttr("transpose_b", opts.transposeB);
                }
                if (opts.inputQuantMode == null) continue;
                opBuilder.setAttr("input_quant_mode", opts.inputQuantMode);
            }
        }
        return new QuantizedMatMulWithBiasAndReluAndRequantize<W>(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options inputQuantMode(String inputQuantMode) {
        return new Options().inputQuantMode(inputQuantMode);
    }

    public Output<W> out() {
        return this.out;
    }

    public Output<TFloat32> minOut() {
        return this.minOut;
    }

    public Output<TFloat32> maxOut() {
        return this.maxOut;
    }

    @OpInputsMetadata(outputsClass=QuantizedMatMulWithBiasAndReluAndRequantize.class)
    public static class Inputs
    extends RawOpInputs<QuantizedMatMulWithBiasAndReluAndRequantize<?>> {
        public final Operand<? extends TNumber> a;
        public final Operand<? extends TNumber> b;
        public final Operand<? extends TNumber> bias;
        public final Operand<TFloat32> minA;
        public final Operand<TFloat32> maxA;
        public final Operand<TFloat32> minB;
        public final Operand<TFloat32> maxB;
        public final Operand<TFloat32> minFreezedOutput;
        public final Operand<TFloat32> maxFreezedOutput;
        public final DataType T1;
        public final DataType T2;
        public final DataType Tbias;
        public final DataType Toutput;
        public final boolean transposeA;
        public final boolean transposeB;
        public final String inputQuantMode;

        public Inputs(GraphOperation op) {
            super(new QuantizedMatMulWithBiasAndReluAndRequantize(op), op, Arrays.asList("T1", "T2", "Tbias", "Toutput", "transpose_a", "transpose_b", "input_quant_mode"));
            int inputIndex = 0;
            this.a = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.bias = op.input(inputIndex++);
            this.minA = op.input(inputIndex++);
            this.maxA = op.input(inputIndex++);
            this.minB = op.input(inputIndex++);
            this.maxB = op.input(inputIndex++);
            this.minFreezedOutput = op.input(inputIndex++);
            this.maxFreezedOutput = op.input(inputIndex++);
            this.T1 = op.attributes().getAttrType("T1");
            this.T2 = op.attributes().getAttrType("T2");
            this.Tbias = op.attributes().getAttrType("Tbias");
            this.Toutput = op.attributes().getAttrType("Toutput");
            this.transposeA = op.attributes().getAttrBool("transpose_a");
            this.transposeB = op.attributes().getAttrBool("transpose_b");
            this.inputQuantMode = op.attributes().getAttrString("input_quant_mode");
        }
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private String inputQuantMode;

        private Options() {
        }

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options inputQuantMode(String inputQuantMode) {
            this.inputQuantMode = inputQuantMode;
            return this;
        }
    }
}

