/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="DecodePaddedRaw", inputsClass=Inputs.class)
public final class DecodePaddedRaw<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DecodePaddedRaw";
    private Output<T> output;

    public DecodePaddedRaw(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> DecodePaddedRaw<T> create(Scope scope, Operand<TString> inputBytes, Operand<TInt32> fixedLength, Class<T> outType, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputBytes.asOutput());
        opBuilder.addInput(fixedLength.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        if (options != null) {
            for (Options opts : options) {
                if (opts.littleEndian == null) continue;
                opBuilder.setAttr("little_endian", opts.littleEndian);
            }
        }
        return new DecodePaddedRaw<T>(opBuilder.build());
    }

    public static Options littleEndian(Boolean littleEndian) {
        return new Options().littleEndian(littleEndian);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=DecodePaddedRaw.class)
    public static class Inputs
    extends RawOpInputs<DecodePaddedRaw<?>> {
        public final Operand<TString> inputBytes;
        public final Operand<TInt32> fixedLength;
        public final DataType outType;
        public final boolean littleEndian;

        public Inputs(GraphOperation op) {
            super(new DecodePaddedRaw(op), op, Arrays.asList("out_type", "little_endian"));
            int inputIndex = 0;
            this.inputBytes = op.input(inputIndex++);
            this.fixedLength = op.input(inputIndex++);
            this.outType = op.attributes().getAttrType("out_type");
            this.littleEndian = op.attributes().getAttrBool("little_endian");
        }
    }

    public static class Options {
        private Boolean littleEndian;

        private Options() {
        }

        public Options littleEndian(Boolean littleEndian) {
            this.littleEndian = littleEndian;
            return this;
        }
    }
}

