/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="CombinedNonMaxSuppression", inputsClass=Inputs.class)
public final class CombinedNonMaxSuppression
extends RawOp {
    public static final String OP_NAME = "CombinedNonMaxSuppression";
    private Output<TFloat32> nmsedBoxes;
    private Output<TFloat32> nmsedScores;
    private Output<TFloat32> nmsedClasses;
    private Output<TInt32> validDetections;

    public CombinedNonMaxSuppression(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.nmsedBoxes = operation.output(outputIdx++);
        this.nmsedScores = operation.output(outputIdx++);
        this.nmsedClasses = operation.output(outputIdx++);
        this.validDetections = operation.output(outputIdx++);
    }

    public static CombinedNonMaxSuppression create(Scope scope, Operand<TFloat32> boxes, Operand<TFloat32> scores, Operand<TInt32> maxOutputSizePerClass, Operand<TInt32> maxTotalSize, Operand<TFloat32> iouThreshold, Operand<TFloat32> scoreThreshold, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(maxOutputSizePerClass.asOutput());
        opBuilder.addInput(maxTotalSize.asOutput());
        opBuilder.addInput(iouThreshold.asOutput());
        opBuilder.addInput(scoreThreshold.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.padPerClass != null) {
                    opBuilder.setAttr("pad_per_class", opts.padPerClass);
                }
                if (opts.clipBoxes == null) continue;
                opBuilder.setAttr("clip_boxes", opts.clipBoxes);
            }
        }
        return new CombinedNonMaxSuppression(opBuilder.build());
    }

    public static Options padPerClass(Boolean padPerClass) {
        return new Options().padPerClass(padPerClass);
    }

    public static Options clipBoxes(Boolean clipBoxes) {
        return new Options().clipBoxes(clipBoxes);
    }

    public Output<TFloat32> nmsedBoxes() {
        return this.nmsedBoxes;
    }

    public Output<TFloat32> nmsedScores() {
        return this.nmsedScores;
    }

    public Output<TFloat32> nmsedClasses() {
        return this.nmsedClasses;
    }

    public Output<TInt32> validDetections() {
        return this.validDetections;
    }

    @OpInputsMetadata(outputsClass=CombinedNonMaxSuppression.class)
    public static class Inputs
    extends RawOpInputs<CombinedNonMaxSuppression> {
        public final Operand<TFloat32> boxes;
        public final Operand<TFloat32> scores;
        public final Operand<TInt32> maxOutputSizePerClass;
        public final Operand<TInt32> maxTotalSize;
        public final Operand<TFloat32> iouThreshold;
        public final Operand<TFloat32> scoreThreshold;
        public final boolean padPerClass;
        public final boolean clipBoxes;

        public Inputs(GraphOperation op) {
            super(new CombinedNonMaxSuppression(op), op, Arrays.asList("pad_per_class", "clip_boxes"));
            int inputIndex = 0;
            this.boxes = op.input(inputIndex++);
            this.scores = op.input(inputIndex++);
            this.maxOutputSizePerClass = op.input(inputIndex++);
            this.maxTotalSize = op.input(inputIndex++);
            this.iouThreshold = op.input(inputIndex++);
            this.scoreThreshold = op.input(inputIndex++);
            this.padPerClass = op.attributes().getAttrBool("pad_per_class");
            this.clipBoxes = op.attributes().getAttrBool("clip_boxes");
        }
    }

    public static class Options {
        private Boolean padPerClass;
        private Boolean clipBoxes;

        private Options() {
        }

        public Options padPerClass(Boolean padPerClass) {
            this.padPerClass = padPerClass;
            return this;
        }

        public Options clipBoxes(Boolean clipBoxes) {
            this.clipBoxes = clipBoxes;
            return this;
        }
    }
}

