/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.ByteSequenceProvider;
import org.tensorflow.internal.buffer.ByteSequenceTensorBuffer;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayout;
import org.tensorflow.ndarray.buffer.layout.DataLayouts;
import org.tensorflow.ndarray.impl.dense.DenseNdArray;
import org.tensorflow.ndarray.impl.sparse.SparseNdArray;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class TStringMapper
extends TensorMapper<TString> {
    private static final DataLayout<DataBuffer<byte[]>, String> UTF_8_LAYOUT = DataLayouts.ofStrings(StandardCharsets.UTF_8);

    @Override
    protected TString mapDense(RawTensor tensor) {
        ByteSequenceTensorBuffer buffer = TensorBuffers.toStrings(TStringMapper.nativeHandle(tensor), tensor.shape().size());
        return new DenseTString(tensor, buffer, UTF_8_LAYOUT);
    }

    @Override
    protected SparseTensor<TString> mapSparse(TInt64 indices, TString values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTString(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTString
    extends SparseNdArray<String, TString>
    implements TString,
    SparseTensor<TString> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TString> type() {
            return TString.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TString values() {
            return (TString)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        @Override
        public TString using(Charset charset) {
            return new SparseTString(this.indices(), this.values().using(charset), this.denseShape(), this.tensorScope, false);
        }

        @Override
        public NdArray<byte[]> asBytes() {
            return SparseNdArray.create(byte[].class, this.indices(), this.values().asBytes(), this.dimensions());
        }

        SparseTString(TInt64 indices, TString values, TInt64 denseShape, PointerScope tensorScope) {
            this(indices, values, denseShape, tensorScope, true);
        }

        private SparseTString(TInt64 indices, TString values, TInt64 denseShape, PointerScope tensorScope, boolean extendScope) {
            super(String.class, indices, values, "", SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = extendScope ? tensorScope.extend() : tensorScope;
        }
    }

    private static final class DenseTString
    extends DenseNdArray<String>
    implements TStringInternal {
        final RawTensor rawTensor;
        final ByteSequenceTensorBuffer buffer;

        @Override
        public <T> void init(ByteSequenceProvider<T> byteSequenceProvider) {
            this.buffer.init(byteSequenceProvider);
        }

        @Override
        public TString using(Charset charset) {
            return new DenseTString(this.rawTensor, this.buffer, DataLayouts.ofStrings(charset));
        }

        @Override
        public NdArray<byte[]> asBytes() {
            return NdArrays.wrap(this.shape(), this.buffer);
        }

        public Class<TString> type() {
            return TString.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTString(RawTensor rawTensor, ByteSequenceTensorBuffer buffer, DataLayout<DataBuffer<byte[]>, String> layout) {
            super(layout.applyTo(buffer), rawTensor.shape());
            this.rawTensor = rawTensor;
            this.buffer = buffer;
        }
    }

    static interface TStringInternal
    extends TString {
        public <T> void init(ByteSequenceProvider<T> var1);
    }
}

