/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.debugging;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DebugIdentityV3", inputsClass=Inputs.class)
public final class DebugIdentity<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DebugIdentityV3";
    private Output<T> output;

    public DebugIdentity(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> DebugIdentity<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DebugIdentity");
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceName != null) {
                    opBuilder.setAttr("device_name", opts.deviceName);
                }
                if (opts.tensorName != null) {
                    opBuilder.setAttr("tensor_name", opts.tensorName);
                }
                if (opts.ioOfNode != null) {
                    opBuilder.setAttr("io_of_node", opts.ioOfNode);
                }
                if (opts.isInput != null) {
                    opBuilder.setAttr("is_input", opts.isInput);
                }
                if (opts.ioIndex != null) {
                    opBuilder.setAttr("io_index", opts.ioIndex);
                }
                if (opts.debugUrls != null) {
                    String[] debugUrlsArray = new String[opts.debugUrls.size()];
                    for (int i = 0; i < debugUrlsArray.length; ++i) {
                        debugUrlsArray[i] = opts.debugUrls.get(i);
                    }
                    opBuilder.setAttr("debug_urls", debugUrlsArray);
                }
                if (opts.gatedGrpc == null) continue;
                opBuilder.setAttr("gated_grpc", opts.gatedGrpc);
            }
        }
        return new DebugIdentity<T>(opBuilder.build());
    }

    public static Options deviceName(String deviceName) {
        return new Options().deviceName(deviceName);
    }

    public static Options tensorName(String tensorName) {
        return new Options().tensorName(tensorName);
    }

    public static Options ioOfNode(String ioOfNode) {
        return new Options().ioOfNode(ioOfNode);
    }

    public static Options isInput(Boolean isInput) {
        return new Options().isInput(isInput);
    }

    public static Options ioIndex(Long ioIndex) {
        return new Options().ioIndex(ioIndex);
    }

    public static Options debugUrls(List<String> debugUrls) {
        return new Options().debugUrls(debugUrls);
    }

    public static Options debugUrls(String ... debugUrls) {
        return new Options().debugUrls(debugUrls);
    }

    public static Options gatedGrpc(Boolean gatedGrpc) {
        return new Options().gatedGrpc(gatedGrpc);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=DebugIdentity.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<DebugIdentity<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final String deviceName;
        public final String tensorName;
        public final String ioOfNode;
        public final boolean isInput;
        public final long ioIndex;
        public final String[] debugUrls;
        public final boolean gatedGrpc;

        public Inputs(GraphOperation op) {
            super(new DebugIdentity(op), op, Arrays.asList("T", "device_name", "tensor_name", "io_of_node", "is_input", "io_index", "debug_urls", "gated_grpc"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.deviceName = op.attributes().getAttrString("device_name");
            this.tensorName = op.attributes().getAttrString("tensor_name");
            this.ioOfNode = op.attributes().getAttrString("io_of_node");
            this.isInput = op.attributes().getAttrBool("is_input");
            this.ioIndex = op.attributes().getAttrInt("io_index");
            this.debugUrls = op.attributes().getAttrStringList("debug_urls");
            this.gatedGrpc = op.attributes().getAttrBool("gated_grpc");
        }
    }

    public static class Options {
        private String deviceName;
        private String tensorName;
        private String ioOfNode;
        private Boolean isInput;
        private Long ioIndex;
        private List<String> debugUrls;
        private Boolean gatedGrpc;

        private Options() {
        }

        public Options deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Options tensorName(String tensorName) {
            this.tensorName = tensorName;
            return this;
        }

        public Options ioOfNode(String ioOfNode) {
            this.ioOfNode = ioOfNode;
            return this;
        }

        public Options isInput(Boolean isInput) {
            this.isInput = isInput;
            return this;
        }

        public Options ioIndex(Long ioIndex) {
            this.ioIndex = ioIndex;
            return this;
        }

        public Options debugUrls(List<String> debugUrls) {
            this.debugUrls = debugUrls;
            return this;
        }

        public Options debugUrls(String ... debugUrls) {
            this.debugUrls = Arrays.asList(debugUrls);
            return this;
        }

        public Options gatedGrpc(Boolean gatedGrpc) {
            this.gatedGrpc = gatedGrpc;
            return this;
        }
    }
}

