/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorListFromTensor", inputsClass=Inputs.class)
public final class TensorListFromTensor
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TensorListFromTensor";
    private Output<? extends TType> outputHandle;

    public TensorListFromTensor(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputHandle = operation.output(outputIdx++);
    }

    public static TensorListFromTensor create(Scope scope, Operand<? extends TType> tensor, Operand<? extends TNumber> elementShape) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(tensor.asOutput());
        opBuilder.addInput(elementShape.asOutput());
        return new TensorListFromTensor(opBuilder.build());
    }

    public Output<? extends TType> outputHandle() {
        return this.outputHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.outputHandle;
    }

    @OpInputsMetadata(outputsClass=TensorListFromTensor.class)
    public static class Inputs
    extends RawOpInputs<TensorListFromTensor> {
        public final Operand<? extends TType> tensor;
        public final Operand<? extends TNumber> elementShape;
        public final DataType elementDtype;
        public final DataType shapeType;

        public Inputs(GraphOperation op) {
            super(new TensorListFromTensor(op), op, Arrays.asList("element_dtype", "shape_type"));
            int inputIndex = 0;
            this.tensor = op.input(inputIndex++);
            this.elementShape = op.input(inputIndex++);
            this.elementDtype = op.attributes().getAttrType("element_dtype");
            this.shapeType = op.attributes().getAttrType("shape_type");
        }
    }
}

