/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="AnonymousMutableHashTableOfTensors", inputsClass=Inputs.class)
public final class AnonymousMutableHashTableOfTensors
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "AnonymousMutableHashTableOfTensors";
    private Output<? extends TType> tableHandle;

    public AnonymousMutableHashTableOfTensors(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.tableHandle = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TType> AnonymousMutableHashTableOfTensors create(Scope scope, Class<T> keyDtype, Class<U> valueDtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("key_dtype", Operands.toDataType(keyDtype));
        opBuilder.setAttr("value_dtype", Operands.toDataType(valueDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.valueShape == null) continue;
                opBuilder.setAttr("value_shape", opts.valueShape);
            }
        }
        return new AnonymousMutableHashTableOfTensors(opBuilder.build());
    }

    public static Options valueShape(Shape valueShape) {
        return new Options().valueShape(valueShape);
    }

    public Output<? extends TType> tableHandle() {
        return this.tableHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.tableHandle;
    }

    @OpInputsMetadata(outputsClass=AnonymousMutableHashTableOfTensors.class)
    public static class Inputs
    extends RawOpInputs<AnonymousMutableHashTableOfTensors> {
        public final DataType keyDtype;
        public final DataType valueDtype;
        public final Shape valueShape;

        public Inputs(GraphOperation op) {
            super(new AnonymousMutableHashTableOfTensors(op), op, Arrays.asList("key_dtype", "value_dtype", "value_shape"));
            boolean inputIndex = false;
            this.keyDtype = op.attributes().getAttrType("key_dtype");
            this.valueDtype = op.attributes().getAttrType("value_dtype");
            this.valueShape = op.attributes().getAttrShape("value_shape");
        }
    }

    public static class Options {
        private Shape valueShape;

        private Options() {
        }

        public Options valueShape(Shape valueShape) {
            this.valueShape = valueShape;
            return this;
        }
    }
}

